/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.gitignore;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import nl.basjes.gitignore.GitIgnore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitIgnoreFileSet
implements FileFilter {
    private static final Logger LOG = LoggerFactory.getLogger(GitIgnoreFileSet.class);
    private final TreeMap<String, List<GitIgnore>> gitIgnores = new TreeMap();
    private final File projectBaseDir;
    private boolean verbose = false;
    private boolean assumeProjectRelativeQueries = false;

    public File getProjectBaseDir() {
        return this.projectBaseDir;
    }

    public GitIgnoreFileSet(File projectBaseDir) {
        this(projectBaseDir, true);
    }

    public GitIgnoreFileSet(File projectBaseDir, boolean autoload) {
        this.projectBaseDir = projectBaseDir;
        if (autoload) {
            this.addAllGitIgnoreFiles();
        }
    }

    public GitIgnoreFileSet setVerbose(boolean verbose) {
        this.verbose = verbose;
        this.gitIgnores.values().forEach(gitIgnoreList -> gitIgnoreList.forEach(gitIgnore -> gitIgnore.setVerbose(verbose)));
        return this;
    }

    public GitIgnoreFileSet setAssumeProjectRelativeQueries(boolean assumeProjectRelativeQueries) {
        this.assumeProjectRelativeQueries = assumeProjectRelativeQueries;
        return this;
    }

    public GitIgnoreFileSet assumeQueriesAreProjectRelative() {
        return this.setAssumeProjectRelativeQueries(true);
    }

    public boolean isAssumeQueriesAreProjectRelative() {
        return this.assumeProjectRelativeQueries;
    }

    public GitIgnoreFileSet assumeQueriesIncludeProjectBaseDir() {
        return this.setAssumeProjectRelativeQueries(false);
    }

    public boolean isAssumeQueriesIncludeProjectBaseDir() {
        return !this.assumeProjectRelativeQueries;
    }

    public void add(GitIgnore gitIgnore) {
        this.gitIgnores.computeIfAbsent(gitIgnore.getProjectRelativeBaseDir(), k -> new ArrayList()).add(gitIgnore);
        gitIgnore.setVerbose(this.verbose);
    }

    public void addGitIgnoreFile(File gitIgnoreFile) {
        try {
            this.add(new GitIgnore(this.getProjectRelative(gitIgnoreFile.getParent()), gitIgnoreFile));
        }
        catch (IOException e) {
            LOG.error("Cannot read {} due to {}. Will skip this file.", (Object)gitIgnoreFile, (Object)e.getMessage());
        }
    }

    public List<Path> addAllGitIgnoreFiles() {
        return this.addAllGitIgnoreFiles(true);
    }

    public List<Path> addAllGitIgnoreFiles(boolean includeGlobalGitignore) {
        return this.addAllGitIgnoreFiles(this.projectBaseDir.toPath(), 128, includeGlobalGitignore);
    }

    static Path getGlobalGitIgnore(String xdgConfigHome, String home) {
        Path ignorePath;
        if (xdgConfigHome != null && !xdgConfigHome.isEmpty()) {
            ignorePath = new File(xdgConfigHome).toPath().resolve("git").resolve("ignore");
        } else if (home != null && !home.isEmpty()) {
            ignorePath = new File(home).toPath().resolve(".config").resolve("git").resolve("ignore");
        } else {
            return null;
        }
        if (Files.isRegularFile(ignorePath, new LinkOption[0])) {
            return ignorePath;
        }
        return null;
    }

    public Path addGlobalGitIgnore() {
        Path ignorePath = GitIgnoreFileSet.getGlobalGitIgnore(System.getenv("XDG_CONFIG_HOME"), System.getenv("HOME"));
        if (ignorePath != null) {
            try {
                this.add(new GitIgnore("/", ignorePath.toFile()));
                return ignorePath;
            }
            catch (IOException e) {
                LOG.error("Cannot read {} due to {}. Will skip this file.", (Object)ignorePath, (Object)e.getMessage());
                return null;
            }
        }
        return null;
    }

    private List<Path> addAllGitIgnoreFiles(Path current, int maxRecursionDepth, boolean includeGlobalGitignore) {
        String dirPath;
        Path globalGitIgnore;
        ArrayList<Path> loadedGitIgnoreFiles = new ArrayList<Path>();
        ArrayList<Path> subDirs = new ArrayList<Path>();
        if (!Files.isDirectory(current, new LinkOption[0])) {
            LOG.debug("Locate GI: Not DIR  {}", (Object)current);
            return Collections.emptyList();
        }
        if (includeGlobalGitignore && (globalGitIgnore = this.addGlobalGitIgnore()) != null) {
            loadedGitIgnoreFiles.add(globalGitIgnore);
        }
        if (!(dirPath = current.toFile().getPath()).endsWith(File.separator)) {
            dirPath = dirPath + File.separatorChar;
        }
        if (this.ignoreFile(dirPath)) {
            LOG.debug("Locate GI: Ignored  {}", (Object)current);
            return Collections.emptyList();
        }
        LOG.debug("Locate GI: Scan     {}", (Object)current);
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(current);){
            for (Path path : stream) {
                if (Files.isRegularFile(path, new LinkOption[0])) {
                    if (!".gitignore".equals(path.getFileName().toString())) continue;
                    LOG.debug("Locate GI: ADDING   {}", (Object)path);
                    this.addGitIgnoreFile(path.toFile());
                    loadedGitIgnoreFiles.add(path);
                    continue;
                }
                if (!Files.isDirectory(path, new LinkOption[0])) continue;
                subDirs.add(path);
            }
        }
        catch (IOException e) {
            LOG.error("Unable to find .gitignore files in {} due to {}", (Object)this.projectBaseDir, (Object)e.toString());
            return Collections.emptyList();
        }
        int nextMaxRecursionDepth = maxRecursionDepth - 1;
        if (nextMaxRecursionDepth > 0) {
            for (Path subDir : subDirs) {
                loadedGitIgnoreFiles.addAll(this.addAllGitIgnoreFiles(subDir, nextMaxRecursionDepth, false));
            }
        }
        return loadedGitIgnoreFiles;
    }

    public boolean isEmpty() {
        return this.gitIgnores.isEmpty();
    }

    public Boolean isIgnoredFile(String filename) {
        return this.isIgnoredFile(filename, this.assumeProjectRelativeQueries);
    }

    public Boolean isIgnoredFile(String filename, boolean isRelative) {
        Boolean result = null;
        String projectBaseFileName = isRelative ? filename : this.getProjectRelative(filename);
        for (List<GitIgnore> gitIgnoreLists : this.gitIgnores.values()) {
            for (GitIgnore gitIgnore : gitIgnoreLists) {
                Boolean isIgnoredFile = gitIgnore.isIgnoredFile(projectBaseFileName);
                if (isIgnoredFile == null) continue;
                result = isIgnoredFile;
            }
        }
        return result;
    }

    public boolean ignoreFile(String filename) {
        return this.ignoreFile(filename, this.assumeProjectRelativeQueries);
    }

    public boolean ignoreFile(String filename, boolean isProjectRelative) {
        return Boolean.TRUE.equals(this.isIgnoredFile(filename, isProjectRelative));
    }

    public boolean keepFile(String filename) {
        return this.keepFile(filename, this.assumeProjectRelativeQueries);
    }

    public boolean keepFile(String filename, boolean isProjectRelative) {
        return !this.ignoreFile(filename, isProjectRelative);
    }

    private String getProjectRelative(String fileName) {
        String projectBaseDirPath;
        String standardizedFilename = GitIgnore.standardizeFilename(fileName);
        if (standardizedFilename.startsWith(projectBaseDirPath = GitIgnore.standardizeFilename(this.projectBaseDir.getPath()))) {
            return GitIgnore.standardizeFilename(fileName).replaceAll("^\\Q" + projectBaseDirPath + "\\E", "/").replace("//", "/");
        }
        String projectBaseDirAbsolutePath = GitIgnore.standardizeFilename(this.projectBaseDir.getAbsolutePath());
        if (standardizedFilename.startsWith(projectBaseDirAbsolutePath)) {
            return GitIgnore.standardizeFilename(fileName).replaceAll("^\\Q" + projectBaseDirAbsolutePath + "\\E", "/").replace("//", "/");
        }
        throw new IllegalArgumentException("The requested file \"" + standardizedFilename + "\" is not relative to project root and is NOT in the projectBaseDir \"" + projectBaseDirPath + "\"");
    }

    @Override
    public boolean accept(File pathname) {
        return this.keepFile(pathname.getName(), true);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("GitIgnoreFileSet\n");
        sb.append("# Project base directory: ").append(this.projectBaseDir).append(" ( Absolute: ").append(this.projectBaseDir.getAbsoluteFile()).append(" )\n").append("=========================\n");
        for (Map.Entry<String, List<GitIgnore>> gitIgnoreListEntry : this.gitIgnores.entrySet()) {
            for (GitIgnore gitIgnore : gitIgnoreListEntry.getValue()) {
                sb.append(gitIgnore).append("=========================\n");
            }
        }
        return sb.toString();
    }
}

