/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.gitignore;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import nl.basjes.gitignore.GitIgnoreFileSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Utils {
    private static final Logger LOG = LoggerFactory.getLogger(Utils.class);

    private Utils() {
    }

    public static List<Path> findAllNonIgnored(GitIgnoreFileSet gitIgnoreFileSet) {
        return Utils.findAllNonIgnored(gitIgnoreFileSet, gitIgnoreFileSet.getProjectBaseDir().toPath());
    }

    public static List<Path> findAllNonIgnored(GitIgnoreFileSet gitIgnoreFileSet, Path baseDir) {
        return Utils.findAllNonIgnored(gitIgnoreFileSet, baseDir, 128);
    }

    private static List<Path> findAllNonIgnored(GitIgnoreFileSet gitIgnoreFileSet, Path current, int maxRecursionDepth) {
        ArrayList<Path> found = new ArrayList<Path>();
        ArrayList<Path> subDirs = new ArrayList<Path>();
        if (!Files.isDirectory(current, new LinkOption[0])) {
            LOG.debug("Locate GI: Not DIR  {}", (Object)current);
            return Collections.emptyList();
        }
        String dirPath = current.toFile().getPath();
        if (!dirPath.endsWith(File.separator)) {
            dirPath = dirPath + File.separatorChar;
        }
        if (gitIgnoreFileSet.ignoreFile(dirPath)) {
            LOG.debug("Locate GI: Ignored  {}", (Object)current);
            return Collections.emptyList();
        }
        LOG.debug("Locate GI: Scan     {}", (Object)current);
        found.add(current);
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(current);){
            for (Path path : stream) {
                if (!gitIgnoreFileSet.keepFile(path.toString())) continue;
                if (Files.isDirectory(path, new LinkOption[0])) {
                    subDirs.add(path);
                    continue;
                }
                found.add(path);
            }
        }
        catch (IOException e) {
            LOG.error("Unable to list the content of {} due to {}", (Object)current, (Object)e.toString());
            return Collections.emptyList();
        }
        int nextMaxRecursionDepth = maxRecursionDepth - 1;
        if (nextMaxRecursionDepth > 0) {
            for (Path subDir : subDirs) {
                found.addAll(Utils.findAllNonIgnored(gitIgnoreFileSet, subDir, nextMaxRecursionDepth));
            }
        }
        Collections.sort(found);
        return found;
    }
}

