/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.gitignore;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Stream;
import nl.basjes.gitignore.GitIgnore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitIgnoreFileSet
implements FileFilter {
    private static final Logger LOG = LoggerFactory.getLogger(GitIgnoreFileSet.class);
    private final TreeMap<String, GitIgnore> gitIgnores = new TreeMap();
    private final File projectBaseDir;
    private boolean verbose = false;
    private boolean assumeProjectRelativeQueries = false;

    public GitIgnoreFileSet(File projectBaseDir) {
        this(projectBaseDir, true);
    }

    public GitIgnoreFileSet(File projectBaseDir, boolean autoload) {
        this.projectBaseDir = projectBaseDir;
        if (autoload) {
            this.addAllGitIgnoreFiles();
        }
    }

    public GitIgnoreFileSet setVerbose(boolean verbose) {
        this.verbose = verbose;
        this.gitIgnores.values().forEach(gitIgnore -> gitIgnore.setVerbose(verbose));
        return this;
    }

    public GitIgnoreFileSet setAssumeProjectRelativeQueries(boolean assumeProjectRelativeQueries) {
        this.assumeProjectRelativeQueries = assumeProjectRelativeQueries;
        return this;
    }

    public GitIgnoreFileSet assumeQueriesAreProjectRelative() {
        return this.setAssumeProjectRelativeQueries(true);
    }

    public boolean isAssumeQueriesAreProjectRelative() {
        return this.assumeProjectRelativeQueries;
    }

    public GitIgnoreFileSet assumeQueriesIncludeProjectBaseDir() {
        return this.setAssumeProjectRelativeQueries(false);
    }

    public boolean isAssumeQueriesIncludeProjectBaseDir() {
        return !this.assumeProjectRelativeQueries;
    }

    public void add(GitIgnore gitIgnore) {
        this.gitIgnores.put(gitIgnore.getProjectRelativeBaseDir(), gitIgnore);
        gitIgnore.setVerbose(this.verbose);
    }

    public void addGitIgnoreFile(File gitIgnoreFile) {
        try {
            this.add(new GitIgnore(this.getProjectRelative(gitIgnoreFile.getParent()), gitIgnoreFile));
        }
        catch (IOException e) {
            LOG.error("Cannot read {} due to {}. Will skip this file.", (Object)gitIgnoreFile, (Object)e.getMessage());
        }
    }

    public void addAllGitIgnoreFiles() {
        try (Stream<Path> projectFiles = Files.find(this.projectBaseDir.toPath(), 128, (filePath, fileAttr) -> fileAttr.isRegularFile(), new FileVisitOption[0]);){
            projectFiles.filter(filePath -> filePath.getFileName().toString().equals(".gitignore")).forEach(gitIgnoreFile -> this.addGitIgnoreFile(gitIgnoreFile.toFile()));
        }
        catch (IOException e) {
            LOG.error("Unable to find .gitignore files in {} due to {}", (Object)this.projectBaseDir, (Object)e.toString());
        }
    }

    public boolean isEmpty() {
        return this.gitIgnores.isEmpty();
    }

    public Boolean isIgnoredFile(String filename) {
        return this.isIgnoredFile(filename, this.assumeProjectRelativeQueries);
    }

    public Boolean isIgnoredFile(String filename, boolean isRelative) {
        Boolean result = null;
        String projectBaseFileName = isRelative ? filename : this.getProjectRelative(filename);
        for (GitIgnore gitIgnore : this.gitIgnores.values()) {
            Boolean isIgnoredFile = gitIgnore.isIgnoredFile(projectBaseFileName);
            if (isIgnoredFile == null) continue;
            result = isIgnoredFile;
        }
        return result;
    }

    public boolean ignoreFile(String filename) {
        return this.ignoreFile(filename, this.assumeProjectRelativeQueries);
    }

    public boolean ignoreFile(String filename, boolean isProjectRelative) {
        return Boolean.TRUE.equals(this.isIgnoredFile(filename, isProjectRelative));
    }

    public boolean keepFile(String filename) {
        return this.keepFile(filename, this.assumeProjectRelativeQueries);
    }

    public boolean keepFile(String filename, boolean isProjectRelative) {
        return !this.ignoreFile(filename, isProjectRelative);
    }

    private String getProjectRelative(String fileName) {
        String projectBaseDirPath;
        String standardizedFilename = GitIgnore.standardizeFilename(fileName);
        if (standardizedFilename.startsWith(projectBaseDirPath = GitIgnore.standardizeFilename(this.projectBaseDir.getPath()))) {
            return GitIgnore.standardizeFilename(fileName).replaceAll("^\\Q" + projectBaseDirPath + "\\E", "/").replace("//", "/");
        }
        String projectBaseDirAbsolutePath = GitIgnore.standardizeFilename(this.projectBaseDir.getAbsolutePath());
        if (standardizedFilename.startsWith(projectBaseDirAbsolutePath)) {
            return GitIgnore.standardizeFilename(fileName).replaceAll("^\\Q" + projectBaseDirAbsolutePath + "\\E", "/").replace("//", "/");
        }
        throw new IllegalArgumentException("The requested file \"" + standardizedFilename + "\" is not relative to project root and is NOT in the projectBaseDir \"" + projectBaseDirPath + "\"");
    }

    @Override
    public boolean accept(File pathname) {
        return this.keepFile(pathname.getName(), true);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("GitIgnoreFileSet\n");
        sb.append("# Project base directory: ").append(this.projectBaseDir).append(" ( Absolute: ").append(this.projectBaseDir.getAbsoluteFile()).append(" )\n").append("=========================\n");
        for (Map.Entry<String, GitIgnore> gitIgnoreEntry : this.gitIgnores.entrySet()) {
            sb.append(gitIgnoreEntry.getValue()).append("=========================\n");
        }
        return sb.toString();
    }
}

