/*
 * Apache HTTPD & NGINX Access log parsing made easy
 * Copyright (C) 2011-2021 Niels Basjes
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package nl.basjes.parse.httpdlog;

public final class Version {

    public static final String GIT_COMMIT_ID_DESCRIBE_SHORT  = "v5.8";
    public static final String MAVEN_BUILD_TIMESTAMP         = "2022-05-05T15:37:02Z";
    public static final String PROJECT_VERSION               = "5.8";

    public static String getGitCommitIdDescribeShort() {
        return GIT_COMMIT_ID_DESCRIBE_SHORT;
    }

    public static String getBuildTimestamp() {
        return MAVEN_BUILD_TIMESTAMP;
    }

    public static String getProjectVersion() {
        return PROJECT_VERSION;
    }

}
