/*
 * Yet Another UserAgent Analyzer
 * Copyright (C) 2013-2023 Niels Basjes
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package nl.basjes.parse.useragent.trino;

import io.trino.spi.Plugin;

import java.util.HashSet;
import java.util.Set;

public class YauaaPlugin implements Plugin {
    @Override
    public Set<Class<?>> getFunctions() {
        Set<Class<?>> functions = new HashSet<>();
        functions.add(ParseUserAgentFunction.class);
        functions.add(ParseUserAgentFunctionClientHints.class);
        return functions;
    }
}
