/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.config;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MatcherConfig
implements Serializable {
    private final List<String> options;
    private final String matcherSourceFilename;
    private final int matcherSourceLineNumber;
    private final List<ConfigLine> configLines = new ArrayList<ConfigLine>();

    private MatcherConfig() {
        this.options = Collections.emptyList();
        this.matcherSourceFilename = "<<Should never appear after deserialization>>";
        this.matcherSourceLineNumber = -1;
    }

    public MatcherConfig(String matcherSourceFilename, int matcherSourceLineNumber, List<String> options, List<ConfigLine> configLines) {
        this.matcherSourceFilename = matcherSourceFilename;
        this.matcherSourceLineNumber = matcherSourceLineNumber;
        this.options = options;
        this.configLines.addAll(configLines);
    }

    public void add(ConfigLine configLine) {
        this.configLines.add(configLine);
    }

    public List<String> getOptions() {
        return this.options;
    }

    public String getMatcherSourceFilename() {
        return this.matcherSourceFilename;
    }

    public int getMatcherSourceLineNumber() {
        return this.matcherSourceLineNumber;
    }

    public List<ConfigLine> getConfigLines() {
        return this.configLines;
    }

    public String toString() {
        return "MatcherConfig{options=" + this.options + ", matcherSourceFilename='" + this.matcherSourceFilename + '\'' + ", matcherSourceLineNumber=" + this.matcherSourceLineNumber + ", configLines=" + this.configLines + '}';
    }

    public static class ConfigLine
    implements Serializable {
        private final Type type;
        private final String attribute;
        private final Long confidence;
        private final String expression;

        private ConfigLine() {
            this.type = Type.FAIL_IF_FOUND;
            this.attribute = "<<Should never appear after deserialization>>";
            this.confidence = -42L;
            this.expression = "<<Should never appear after deserialization>>";
        }

        public ConfigLine(Type type, String attribute, Long confidence, String expression) {
            this.type = type;
            this.attribute = attribute;
            this.confidence = confidence;
            this.expression = expression;
        }

        public Type getType() {
            return this.type;
        }

        public String getAttribute() {
            return this.attribute;
        }

        public Long getConfidence() {
            return this.confidence;
        }

        public String getExpression() {
            return this.expression;
        }

        public String toString() {
            return "ConfigLine{type=" + (Object)((Object)this.type) + ", attribute='" + this.attribute + '\'' + ", confidence=" + this.confidence + ", expression='" + this.expression + '\'' + '}';
        }

        public static enum Type {
            VARIABLE,
            REQUIRE,
            FAIL_IF_FOUND,
            EXTRACT;

        }
    }
}

