/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.utils;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import nl.basjes.parse.useragent.Version;
import nl.basjes.parse.useragent.analyze.InvalidParserConfigurationException;
import nl.basjes.parse.useragent.utils.YamlUtils;
import nl.basjes.shaded.org.yaml.snakeyaml.nodes.MappingNode;
import nl.basjes.shaded.org.yaml.snakeyaml.nodes.Node;
import nl.basjes.shaded.org.yaml.snakeyaml.nodes.NodeTuple;
import nl.basjes.shaded.org.yaml.snakeyaml.nodes.SequenceNode;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class YauaaVersion {
    private static final Logger LOG = LogManager.getLogger(YauaaVersion.class);

    private YauaaVersion() {
    }

    public static void logVersion(String ... extraLines) {
        YauaaVersion.logVersion(Arrays.asList(extraLines));
    }

    public static void logVersion(List<String> extraLines) {
        String[] lines = new String[]{"For more information: https://yauaa.basjes.nl", "Copyright (C) 2013-2021 Niels Basjes - License Apache 2.0"};
        String version = YauaaVersion.getVersion();
        int width = version.length();
        for (String line : lines) {
            width = Math.max(width, line.length());
        }
        for (String line : extraLines) {
            width = Math.max(width, line.length());
        }
        String padding = YauaaVersion.padding('-', width);
        LOG.info("");
        LOG.info("/-{}-\\", (Object)padding);
        YauaaVersion.logLine(version, width);
        LOG.info("+-{}-+", (Object)padding);
        for (String line : lines) {
            YauaaVersion.logLine(line, width);
        }
        if (!extraLines.isEmpty()) {
            LOG.info("+-{}-+", (Object)padding);
            for (String line : extraLines) {
                YauaaVersion.logLine(line, width);
            }
        }
        LOG.info("\\-{}-/", (Object)padding);
        LOG.info("");
    }

    private static String padding(char letter, int count) {
        StringBuilder sb = new StringBuilder(128);
        for (int i = 0; i < count; ++i) {
            sb.append(letter);
        }
        return sb.toString();
    }

    private static void logLine(String line, int width) {
        if (LOG.isInfoEnabled()) {
            LOG.info("| {}{} |", (Object)line, (Object)YauaaVersion.padding(' ', width - line.length()));
        }
    }

    public static String getVersion() {
        return YauaaVersion.getVersion(Version.getInstance());
    }

    public static String getVersion(AbstractVersion version) {
        return YauaaVersion.getVersion(version.getProjectVersion(), version.getGitCommitIdDescribeShort(), version.getBuildTimeStamp());
    }

    public static String getVersion(String projectVersion, String gitCommitIdDescribeShort, String buildTimestamp) {
        return "Yauaa " + projectVersion + " (" + gitCommitIdDescribeShort + " @ " + buildTimestamp + ")";
    }

    public static String getVersion(String projectVersion, String gitCommitIdDescribeShort, String buildTimestamp, String buildJDKVersion, String targetJREVersion) {
        return "Yauaa " + projectVersion + " (" + gitCommitIdDescribeShort + " @ " + buildTimestamp + " [JDK:" + buildJDKVersion + ";JRE:" + targetJREVersion + "])";
    }

    public static void assertSameVersion(NodeTuple versionNodeTuple, String filename) {
        RulesVersion rulesVersion = new RulesVersion(versionNodeTuple, filename);
        YauaaVersion.assertSameVersion(Version.getInstance(), rulesVersion);
    }

    public static void assertSameVersion(AbstractVersion libraryVersion, AbstractVersion rulesVersion) {
        if (libraryVersion.equals(rulesVersion)) {
            return;
        }
        LOG.error("===============================================");
        LOG.error("==========        FATAL ERROR       ===========");
        LOG.error("vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv");
        LOG.error("");
        LOG.error("Two different Yauaa versions have been loaded:");
        LOG.error("Runtime Library: {}", (Object)libraryVersion);
        LOG.error("Rule sets      : {}", (Object)rulesVersion);
        LOG.error("");
        LOG.error("^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
        LOG.error("===============================================");
        throw new InvalidParserConfigurationException("Two different Yauaa versions have been loaded: \nRuntime Library: " + libraryVersion + "\nRule sets      : " + rulesVersion + "\n");
    }

    private static final class RulesVersion
    extends AbstractVersion {
        private String gitCommitId = "<undefined>";
        private String gitCommitIdDescribeShort = "<undefined>";
        private String buildTimeStamp = "<undefined>";
        private String projectVersion = "<undefined>";
        private String copyright = "<undefined>";
        private String license = "<undefined>";
        private String url = "<undefined>";
        private String buildJDKVersion = "<undefined>";
        private String targetJREVersion = "<undefined>";

        @Override
        public String getGitCommitId() {
            return this.gitCommitId;
        }

        @Override
        public String getGitCommitIdDescribeShort() {
            return this.gitCommitIdDescribeShort;
        }

        @Override
        public String getBuildTimeStamp() {
            return this.buildTimeStamp;
        }

        @Override
        public String getProjectVersion() {
            return this.projectVersion;
        }

        @Override
        public String getCopyright() {
            return this.copyright;
        }

        @Override
        public String getLicense() {
            return this.license;
        }

        @Override
        public String getUrl() {
            return this.url;
        }

        @Override
        public String getBuildJDKVersion() {
            return this.buildJDKVersion;
        }

        @Override
        public String getTargetJREVersion() {
            return this.targetJREVersion;
        }

        RulesVersion(NodeTuple versionNodeTuple, String filename) {
            SequenceNode versionNode = YamlUtils.getValueAsSequenceNode(versionNodeTuple, filename);
            List<Node> versionList = versionNode.getValue();
            block22: for (Node versionEntry : versionList) {
                YamlUtils.requireNodeInstanceOf(MappingNode.class, versionEntry, filename, "The entry MUST be a mapping");
                NodeTuple entry = YamlUtils.getExactlyOneNodeTuple((MappingNode)versionEntry, filename);
                String key = YamlUtils.getKeyAsString(entry, filename);
                String value = YamlUtils.getValueAsString(entry, filename);
                switch (key) {
                    case "git_commit_id": {
                        this.gitCommitId = value;
                        continue block22;
                    }
                    case "git_commit_id_describe_short": {
                        this.gitCommitIdDescribeShort = value;
                        continue block22;
                    }
                    case "build_timestamp": {
                        this.buildTimeStamp = value;
                        continue block22;
                    }
                    case "project_version": {
                        this.projectVersion = value;
                        continue block22;
                    }
                    case "license": {
                        this.license = value;
                        continue block22;
                    }
                    case "copyright": {
                        this.copyright = value;
                        continue block22;
                    }
                    case "url": {
                        this.url = value;
                        continue block22;
                    }
                    case "buildJDKVersion": {
                        this.buildJDKVersion = value;
                        continue block22;
                    }
                    case "targetJREVersion": {
                        this.targetJREVersion = value;
                        continue block22;
                    }
                }
                throw new InvalidParserConfigurationException("Yaml config.(" + filename + ":" + versionNode.getStartMark().getLine() + "): Found unexpected config entry: " + key + ", allowed are 'git_commit_id_describe_short', 'build_timestamp' and 'project_version'");
            }
        }
    }

    public static abstract class AbstractVersion {
        public abstract String getGitCommitId();

        public abstract String getGitCommitIdDescribeShort();

        public abstract String getBuildTimeStamp();

        public abstract String getProjectVersion();

        public abstract String getCopyright();

        public abstract String getLicense();

        public abstract String getUrl();

        public abstract String getBuildJDKVersion();

        public abstract String getTargetJREVersion();

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof AbstractVersion)) {
                return false;
            }
            AbstractVersion version = (AbstractVersion)o;
            return this.getGitCommitId().equals(version.getGitCommitId()) && this.getGitCommitIdDescribeShort().equals(version.getGitCommitIdDescribeShort()) && this.getBuildTimeStamp().equals(version.getBuildTimeStamp()) && this.getProjectVersion().equals(version.getProjectVersion()) && this.getCopyright().equals(version.getCopyright()) && this.getLicense().equals(version.getLicense()) && this.getUrl().equals(version.getUrl()) && this.getBuildJDKVersion().equals(version.getBuildJDKVersion()) && this.getTargetJREVersion().equals(version.getTargetJREVersion());
        }

        public int hashCode() {
            return Objects.hash(this.getGitCommitId(), this.getGitCommitIdDescribeShort(), this.getBuildTimeStamp(), this.getProjectVersion(), this.getCopyright(), this.getLicense(), this.getUrl(), this.getBuildJDKVersion(), this.getTargetJREVersion());
        }

        public String toString() {
            return "Yauaa " + this.getProjectVersion() + " (" + this.getGitCommitIdDescribeShort() + " @ " + this.getBuildTimeStamp() + " [JDK:" + this.getBuildJDKVersion() + ";JRE:" + this.getTargetJREVersion() + "])";
        }
    }
}

