/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import nl.basjes.parse.useragent.analyze.WordRangeVisitor;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public abstract class Splitter {
    protected abstract boolean isSeparator(char var1);

    protected abstract boolean isEndOfStringSeparator(char var1);

    public int findNextSplitStart(char[] chars, int offset) {
        for (int charNr = offset; charNr < chars.length; ++charNr) {
            char theChar = chars[charNr];
            if (this.isEndOfStringSeparator(theChar)) {
                return -1;
            }
            if (this.isSeparator(theChar)) continue;
            return charNr;
        }
        return -1;
    }

    public int findEndOfString(char[] chars, int offset) {
        for (int charNr = offset; charNr < chars.length; ++charNr) {
            char theChar = chars[charNr];
            if (!this.isEndOfStringSeparator(theChar)) continue;
            return charNr;
        }
        return chars.length;
    }

    public int findSplitStart(char[] chars, int split) {
        if (split <= 0) {
            return -1;
        }
        int charNr = 0;
        boolean inSplit = false;
        int currentSplit = 0;
        for (char theChar : chars) {
            if (this.isEndOfStringSeparator(theChar)) {
                return -1;
            }
            if (this.isSeparator(theChar)) {
                if (inSplit) {
                    inSplit = false;
                }
            } else if (!inSplit) {
                inSplit = true;
                if (++currentSplit == split) {
                    return charNr;
                }
            }
            ++charNr;
        }
        return -1;
    }

    public int findSplitEnd(char[] chars, int startOffset) {
        for (int i = startOffset; i < chars.length; ++i) {
            if (!this.isSeparator(chars[i])) continue;
            return i;
        }
        return chars.length;
    }

    public String getSingleSplit(String value, int split) {
        char[] characters = value.toCharArray();
        int start = this.findSplitStart(characters, split);
        if (start == -1) {
            return null;
        }
        int end = this.findSplitEnd(characters, start);
        return value.substring(start, end);
    }

    public String getSingleSplit(String value, List<Pair<Integer, Integer>> splitList, int split) {
        Pair<Integer, Integer> splitRange = splitList.get(split);
        if (splitRange == null) {
            return null;
        }
        return value.substring((Integer)splitRange.getLeft(), (Integer)splitRange.getRight());
    }

    public String getFirstSplits(String value, int split) {
        char[] characters = value.toCharArray();
        int start = this.findSplitStart(characters, split);
        if (start == -1) {
            return null;
        }
        int end = this.findSplitEnd(characters, start);
        return value.substring(0, end);
    }

    public String getSplitRange(String value, int firstSplit, int lastSplit) {
        if (value == null || lastSplit > 0 && lastSplit < firstSplit) {
            return null;
        }
        char[] characters = value.toCharArray();
        int firstCharOfFirstSplit = this.findSplitStart(characters, firstSplit);
        if (firstCharOfFirstSplit == -1) {
            return null;
        }
        if (lastSplit == -1) {
            return value.substring(firstCharOfFirstSplit, this.findEndOfString(characters, firstCharOfFirstSplit));
        }
        int firstCharOfLastSplit = firstCharOfFirstSplit;
        if (lastSplit != firstSplit && (firstCharOfLastSplit = this.findSplitStart(characters, lastSplit)) == -1) {
            return null;
        }
        int lastCharOfLastSplit = this.findSplitEnd(characters, firstCharOfLastSplit);
        return value.substring(firstCharOfFirstSplit, lastCharOfLastSplit);
    }

    public String getSplitRange(String value, WordRangeVisitor.Range range) {
        return this.getSplitRange(value, range.getFirst(), range.getLast());
    }

    public String getSplitRange(String value, List<Pair<Integer, Integer>> splitList, WordRangeVisitor.Range range) {
        return this.getSplitRange(value, splitList, range.getFirst(), range.getLast());
    }

    public String getSplitRange(String value, List<Pair<Integer, Integer>> splitList, int first, int last) {
        int lastIndex = last - 1;
        int firstIndex = first - 1;
        int splits = splitList.size();
        if (last == -1) {
            lastIndex = splits - 1;
        }
        if (firstIndex < 0 || lastIndex < 0) {
            return null;
        }
        if (firstIndex >= splits || lastIndex >= splits) {
            return null;
        }
        return value.substring((Integer)splitList.get(firstIndex).getLeft(), (Integer)splitList.get(lastIndex).getRight());
    }

    @Nonnull
    public List<String> getSplits(String value, List<Pair<Integer, Integer>> splitList, int first, int last) {
        int lastIndex = last - 1;
        int firstIndex = first - 1;
        int splits = splitList.size();
        if (last == -1) {
            lastIndex = splits - 1;
        }
        if (lastIndex >= splits) {
            lastIndex = splits - 1;
        }
        if (firstIndex < 0 || lastIndex < 0) {
            return Collections.emptyList();
        }
        if (firstIndex >= splits) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (int split = firstIndex; split <= lastIndex; ++split) {
            Pair<Integer, Integer> splitPair = splitList.get(split);
            result.add(value.substring((Integer)splitPair.getLeft(), (Integer)splitPair.getRight()));
        }
        return result;
    }

    public List<Pair<Integer, Integer>> createSplitList(String characters) {
        return this.createSplitList(characters.toCharArray());
    }

    public List<Pair<Integer, Integer>> createSplitList(char[] characters) {
        ArrayList<Pair<Integer, Integer>> result = new ArrayList<Pair<Integer, Integer>>(8);
        int offset = this.findSplitStart(characters, 1);
        if (offset == -1) {
            return result;
        }
        while (offset != -1) {
            int start = offset;
            int end = this.findSplitEnd(characters, start);
            result.add((Pair<Integer, Integer>)new ImmutablePair((Object)start, (Object)end));
            offset = this.findNextSplitStart(characters, end);
        }
        return result;
    }
}

