/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.analyze.treewalker.steps.walk.stepdown;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Predicate;
import nl.basjes.parse.useragent.analyze.treewalker.steps.Step;
import nl.basjes.shaded.org.antlr.v4.runtime.ParserRuleContext;
import nl.basjes.shaded.org.antlr.v4.runtime.tree.ParseTree;

public class ChildIterable {
    private final boolean privateNumberRange;
    private final int start;
    private final int end;
    private final Predicate<ParseTree> isWantedClassPredicate;

    public ChildIterable(boolean privateNumberRange, int start, int end, Predicate<ParseTree> isWantedClassPredicate) {
        this.privateNumberRange = privateNumberRange;
        this.start = start;
        this.end = end;
        this.isWantedClassPredicate = isWantedClassPredicate;
    }

    public Iterator<ParseTree> iterator(ParserRuleContext treeContext) {
        return new ChildIterator(treeContext);
    }

    class ChildIterator
    implements Iterator<ParseTree> {
        private final Iterator<ParseTree> childIter;
        private Boolean hasNext;
        private int index = 0;
        private ParseTree nextChild;

        ChildIterator(ParserRuleContext treeContext) {
            if (treeContext.children == null) {
                this.childIter = null;
                this.nextChild = null;
                this.hasNext = false;
            } else {
                this.childIter = treeContext.children.iterator();
                this.hasNext = this.findNext();
            }
        }

        private boolean findNext() {
            while (this.childIter.hasNext()) {
                ParseTree nextParseTree = this.childIter.next();
                if (Step.treeIsSeparator(nextParseTree)) continue;
                if (!ChildIterable.this.privateNumberRange) {
                    ++this.index;
                }
                if (!ChildIterable.this.isWantedClassPredicate.test(nextParseTree)) continue;
                if (ChildIterable.this.privateNumberRange) {
                    ++this.index;
                }
                if (this.index > ChildIterable.this.end) {
                    this.nextChild = null;
                    return false;
                }
                if (ChildIterable.this.start > this.index) continue;
                this.nextChild = nextParseTree;
                return true;
            }
            this.nextChild = null;
            return false;
        }

        @Override
        public boolean hasNext() {
            if (this.hasNext == null) {
                this.hasNext = this.findNext();
            }
            return this.hasNext;
        }

        @Override
        public ParseTree next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.hasNext = null;
            return this.nextChild;
        }
    }
}

