/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.utils;

import org.apache.commons.logging.LogFactory;
import org.apache.logging.log4j.LogManager;
import org.slf4j.LoggerFactory;

public class CheckLoggingDependencies {
    void verifyLog4j2Dependencies() {
        try {
            LogManager.getLogger((String)"Verify Logging Dependencies (Log4J2)");
        }
        catch (NoClassDefFoundError e) {
            throw new InvalidLoggingDependencyException("Failed loading Log4J2 (Not present)", e);
        }
    }

    void verifySlf4jDependencies() {
        try {
            LoggerFactory.getLogger((String)"Verify Logging Dependencies (Slf4j)");
        }
        catch (NoClassDefFoundError e) {
            throw new InvalidLoggingDependencyException("Failed testing SLF4J (Not present)", e);
        }
    }

    void verifyJCLDependencies() {
        try {
            LogFactory.getLog((String)"Verify Logging Dependencies (JCL)");
        }
        catch (NoClassDefFoundError e) {
            throw new InvalidLoggingDependencyException("Failed testing JCL (Not present)", e);
        }
    }

    public static void verifyLoggingDependencies() {
        CheckLoggingDependencies ldt = new CheckLoggingDependencies();
        ldt.verifyLog4j2Dependencies();
        ldt.verifySlf4jDependencies();
        ldt.verifyJCLDependencies();
    }

    public static class InvalidLoggingDependencyException
    extends RuntimeException {
        public InvalidLoggingDependencyException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

