/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.classify;

import nl.basjes.parse.useragent.UserAgent;
import nl.basjes.parse.useragent.classify.DeviceClass;

public final class UserAgentClassifier {
    private UserAgentClassifier() {
    }

    public static DeviceClass getDeviceClass(UserAgent userAgent) {
        switch (userAgent.getValue("DeviceClass")) {
            case "Desktop": {
                return DeviceClass.DESKTOP;
            }
            case "Anonymized": {
                return DeviceClass.ANONYMIZED;
            }
            case "Mobile": {
                return DeviceClass.MOBILE;
            }
            case "Tablet": {
                return DeviceClass.TABLET;
            }
            case "Phone": {
                return DeviceClass.PHONE;
            }
            case "Watch": {
                return DeviceClass.WATCH;
            }
            case "Virtual Reality": {
                return DeviceClass.VIRTUAL_REALITY;
            }
            case "eReader": {
                return DeviceClass.E_READER;
            }
            case "Set-top box": {
                return DeviceClass.SET_TOP_BOX;
            }
            case "TV": {
                return DeviceClass.TV;
            }
            case "Game Console": {
                return DeviceClass.GAME_CONSOLE;
            }
            case "Handheld Game Console": {
                return DeviceClass.HANDHELD_GAME_CONSOLE;
            }
            case "Home Appliance": {
                return DeviceClass.HOME_APPLIANCE;
            }
            case "Robot": {
                return DeviceClass.ROBOT;
            }
            case "Robot Mobile": {
                return DeviceClass.ROBOT_MOBILE;
            }
            case "Robot Imitator": {
                return DeviceClass.ROBOT_IMITATOR;
            }
            case "Hacker": {
                return DeviceClass.HACKER;
            }
            case "Unknown": {
                return DeviceClass.UNKNOWN;
            }
        }
        return DeviceClass.UNCLASSIFIED;
    }

    public static boolean isNormalConsumerDevice(UserAgent userAgent) {
        switch (UserAgentClassifier.getDeviceClass(userAgent)) {
            case DESKTOP: 
            case MOBILE: 
            case TABLET: 
            case PHONE: 
            case WATCH: 
            case VIRTUAL_REALITY: 
            case E_READER: 
            case SET_TOP_BOX: 
            case TV: 
            case GAME_CONSOLE: 
            case HANDHELD_GAME_CONSOLE: 
            case HOME_APPLIANCE: {
                return true;
            }
        }
        return false;
    }

    public static boolean isMobile(UserAgent userAgent) {
        switch (UserAgentClassifier.getDeviceClass(userAgent)) {
            case MOBILE: 
            case TABLET: 
            case PHONE: 
            case WATCH: 
            case VIRTUAL_REALITY: 
            case E_READER: 
            case HANDHELD_GAME_CONSOLE: 
            case ROBOT_MOBILE: {
                return true;
            }
        }
        return false;
    }

    public static boolean isHuman(UserAgent userAgent) {
        switch (UserAgentClassifier.getDeviceClass(userAgent)) {
            case DESKTOP: 
            case MOBILE: 
            case TABLET: 
            case PHONE: 
            case WATCH: 
            case VIRTUAL_REALITY: 
            case E_READER: 
            case SET_TOP_BOX: 
            case TV: 
            case GAME_CONSOLE: 
            case HANDHELD_GAME_CONSOLE: 
            case HOME_APPLIANCE: 
            case ANONYMIZED: {
                return true;
            }
        }
        return false;
    }

    public static boolean isDeliberateMisuse(UserAgent userAgent) {
        switch (UserAgentClassifier.getDeviceClass(userAgent)) {
            case ANONYMIZED: 
            case ROBOT_IMITATOR: 
            case HACKER: {
                return true;
            }
        }
        return false;
    }
}

