/*
 * Decompiled with CFR 0.152.
 */
package liqp;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import liqp.Insertion;
import liqp.blocks.Block;
import liqp.blocks.Capture;
import liqp.blocks.Case;
import liqp.blocks.Comment;
import liqp.blocks.Cycle;
import liqp.blocks.For;
import liqp.blocks.If;
import liqp.blocks.Ifchanged;
import liqp.blocks.Raw;
import liqp.blocks.Tablerow;
import liqp.blocks.Unless;
import liqp.tags.Assign;
import liqp.tags.Break;
import liqp.tags.Continue;
import liqp.tags.Decrement;
import liqp.tags.Include;
import liqp.tags.IncludeRelative;
import liqp.tags.Increment;

public final class Insertions {
    private final Map<String, Insertion> map;
    private final Set<String> blockNames;
    private final Set<String> tagNames;
    public static final Insertions EMPTY = new Insertions(Collections.emptyMap());
    public static final Insertions STANDARD_INSERTIONS = Insertions.of(new Assign(), new Break(), new Capture(), new Case(), new Comment(), new Continue(), new Cycle(), new Decrement(), new For(), new If(), new Ifchanged(), new Include(), new Increment(), new Raw(), new Tablerow(), new Unless());
    public static final Insertions JEKYLL_INSERTIONS = STANDARD_INSERTIONS.mergeWith(Insertions.of(new IncludeRelative()));

    public static Insertions of(Collection<Insertion> insertions) {
        if (insertions.isEmpty()) {
            return EMPTY;
        }
        return new Insertions(insertions.stream().collect(Collectors.toMap(Insertion::getName, Function.identity(), (a, b) -> b)));
    }

    public static Insertions of(Insertion ... insertions) {
        return Insertions.of(Arrays.asList(insertions));
    }

    public static Insertions of(Map<String, Insertion> insertions) {
        if (insertions.isEmpty()) {
            return EMPTY;
        }
        return new Insertions(insertions);
    }

    private Insertions(Map<String, Insertion> insertions) {
        Objects.requireNonNull(insertions);
        this.map = new HashMap<String, Insertion>(insertions);
        this.blockNames = Collections.unmodifiableSet(this.getNames(en -> en.getValue() instanceof Block));
        this.tagNames = Collections.unmodifiableSet(this.getNames(en -> !(en.getValue() instanceof Block)));
    }

    public Insertions mergeWith(Insertions other) {
        Objects.requireNonNull(other);
        if (other == this || other.map.isEmpty()) {
            return this;
        }
        if (this.map.isEmpty()) {
            return other;
        }
        HashMap<String, Insertion> newMap = new HashMap<String, Insertion>(this.map);
        newMap.putAll(other.map);
        return new Insertions(newMap);
    }

    private Set<String> getNames(Predicate<? super Map.Entry<String, Insertion>> predicate) {
        return this.map.entrySet().stream().filter(predicate).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    Set<String> getBlockNames() {
        return this.blockNames;
    }

    Set<String> getTagNames() {
        return this.tagNames;
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Insertions)) {
            return false;
        }
        return ((Insertions)obj).map.equals(this.map);
    }

    public String toString() {
        if (this.map.isEmpty()) {
            return this.getClass().getName() + ".EMPTY";
        }
        return super.toString() + this.map;
    }

    public Insertion get(String name) {
        return this.map.get(name);
    }

    public Collection<Insertion> values() {
        return Collections.unmodifiableCollection(this.map.values());
    }
}

