/*
 * Decompiled with CFR 0.152.
 */
package liqp;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import liqp.PlainBigDecimal;
import liqp.RenderTransformer;
import liqp.TemplateContext;
import liqp.filters.date.CustomDateFormatRegistry;
import liqp.filters.date.Parser;
import liqp.nodes.AtomNode;

public abstract class LValue {
    public static final LValue BREAK = new LValue(){

        public String toString() {
            return "";
        }
    };
    public static final LValue CONTINUE = new LValue(){

        public String toString() {
            return "";
        }
    };
    public static DateTimeFormatter rubyDateTimeFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss XX");

    public static boolean areEqual(Object a, Object b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a instanceof Number && b instanceof Number) {
            double delta = ((Number)a).doubleValue() - ((Number)b).doubleValue();
            return Math.abs(delta) < 1.0E-11;
        }
        if (LValue.isEmpty(a) && LValue.isEmpty(b)) {
            return true;
        }
        return a.equals(b);
    }

    private static boolean isEmpty(Object val) {
        if (AtomNode.isEmpty(val)) {
            return true;
        }
        if (val instanceof CharSequence) {
            return ((CharSequence)val).length() == 0;
        }
        if (val instanceof Collection) {
            return ((Collection)val).isEmpty();
        }
        if (val instanceof Map) {
            return ((Map)val).isEmpty();
        }
        if (val.getClass().isArray()) {
            return ((Object[])val).length == 0;
        }
        return false;
    }

    public Object[] asArray(Object value, TemplateContext context) {
        if (value == null) {
            return new Object[0];
        }
        if (value.getClass().isArray()) {
            return (Object[])value;
        }
        if (value instanceof Collection) {
            return ((Collection)value).toArray();
        }
        if (LValue.isTemporal(value)) {
            value = LValue.asTemporal(value, context);
            return LValue.temporalAsArray((ZonedDateTime)value);
        }
        return new Object[]{value};
    }

    public List<?> asList(Object value, TemplateContext context) {
        if (value == null) {
            return Collections.emptyList();
        }
        if (value instanceof List) {
            return (List)value;
        }
        if (value instanceof Collection) {
            return new ArrayList((Collection)value);
        }
        if (value.getClass().isArray()) {
            return Arrays.asList((Object[])value);
        }
        if (LValue.isTemporal(value)) {
            value = LValue.asTemporal(value, context);
            return Arrays.asList(LValue.temporalAsArray((ZonedDateTime)value));
        }
        return Collections.singletonList(value);
    }

    public static Object[] temporalAsArray(ZonedDateTime time) {
        int sec = time.get(ChronoField.SECOND_OF_MINUTE);
        int min = time.getMinute();
        int hour = time.getHour();
        int day = time.getDayOfMonth();
        int month = time.get(ChronoField.MONTH_OF_YEAR);
        int year = time.get(ChronoField.YEAR);
        int wday = time.getDayOfWeek().getValue();
        int yday = time.get(ChronoField.DAY_OF_YEAR);
        boolean isdst = time.getZone().getRules().isDaylightSavings(time.toInstant());
        String zone = time.getZone().getId();
        return new Object[]{sec, min, hour, day, month, year, wday, yday, isdst, zone};
    }

    public static TemporalAccessor asTemporal(Object value, TemplateContext context) {
        ZonedDateTime time = ZonedDateTime.now();
        if (value instanceof TemporalAccessor) {
            return (TemporalAccessor)value;
        }
        if (CustomDateFormatRegistry.isCustomDateType(value)) {
            time = CustomDateFormatRegistry.getFromCustomType(value);
        }
        return time;
    }

    public static ZonedDateTime asRubyDate(Object value, TemplateContext context) {
        ZonedDateTime time = ZonedDateTime.now();
        if (value instanceof TemporalAccessor) {
            time = Parser.getZonedDateTimeFromTemporalAccessor((TemporalAccessor)value, context.getParser().defaultTimeZone);
        } else if (CustomDateFormatRegistry.isCustomDateType(value)) {
            time = CustomDateFormatRegistry.getFromCustomType(value);
        }
        return time;
    }

    public static boolean isTemporal(Object value) {
        boolean isTemporalAccessor = value instanceof TemporalAccessor;
        boolean isCustomDateType = CustomDateFormatRegistry.isCustomDateType(value);
        return isTemporalAccessor || isCustomDateType;
    }

    protected Object[] mapAsArray(Map<?, ?> value) {
        ArrayList<Object[]> keyValuePairs = new ArrayList<Object[]>();
        for (Map.Entry<?, ?> entry : value.entrySet()) {
            keyValuePairs.add(new Object[]{entry.getKey(), entry.getValue()});
        }
        return keyValuePairs.toArray();
    }

    public boolean asBoolean(Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return true;
    }

    public Number asNumber(Object value) throws NumberFormatException {
        if (value == null) {
            return 0;
        }
        if (value instanceof Number) {
            return (Number)value;
        }
        String str = String.valueOf(value).trim();
        return str.matches("\\d+") ? (double)Long.valueOf(str).longValue() : Double.valueOf(str);
    }

    public BigDecimal asStrictNumber(Object number) {
        if (number == null) {
            return null;
        }
        if (number instanceof PlainBigDecimal) {
            return (PlainBigDecimal)number;
        }
        return new PlainBigDecimal(number.toString().trim());
    }

    public static BigDecimal asFormattedNumber(BigDecimal bd) {
        return bd.setScale(Math.max(1, bd.stripTrailingZeros().scale()), RoundingMode.UNNECESSARY);
    }

    public String asString(Object value, TemplateContext context) {
        if (value == null) {
            return "";
        }
        if (LValue.isTemporal(value)) {
            ZonedDateTime time = LValue.asRubyDate(value, context);
            return rubyDateTimeFormat.format(time);
        }
        if (!this.isArray(value)) {
            return String.valueOf(value);
        }
        Object[] array = this.asArray(value, context);
        StringBuilder builder = new StringBuilder();
        for (Object obj : array) {
            builder.append(this.asString(obj, context));
        }
        return builder.toString();
    }

    public Object asAppendableObject(Object value, TemplateContext context) {
        if (value == null) {
            return "";
        }
        if (LValue.isTemporal(value)) {
            ZonedDateTime time = LValue.asRubyDate(value, context);
            return rubyDateTimeFormat.format(time);
        }
        if (!this.isArray(value)) {
            return value;
        }
        Object[] array = this.asArray(value, context);
        RenderTransformer.ObjectAppender.Controller builder = context.newObjectAppender(array.length);
        for (Object obj : array) {
            builder.append(this.asAppendableObject(obj, context));
        }
        return builder.getResult();
    }

    public boolean isArray(Object value) {
        return value != null && (value.getClass().isArray() || value instanceof Collection);
    }

    public boolean isInteger(Object value) {
        return value instanceof Long || value instanceof Integer;
    }

    public boolean isNumber(Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof Number) {
            return true;
        }
        if (String.valueOf(value).trim().matches("\\d+")) {
            return true;
        }
        try {
            Double.parseDouble(String.valueOf(value).trim());
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean isString(Object value) {
        return value != null && value instanceof CharSequence;
    }

    public boolean isTruthy(Object value, TemplateContext context) {
        return !this.isFalsy(value, context);
    }

    public boolean isFalsy(Object value, TemplateContext context) {
        if (value == null) {
            return true;
        }
        if (value instanceof Boolean && !((Boolean)value).booleanValue()) {
            return true;
        }
        if (value instanceof CharSequence && ((CharSequence)value).length() == 0) {
            return true;
        }
        if (this.isArray(value) && this.asArray(value, context).length == 0) {
            return true;
        }
        return value instanceof Map && ((Map)value).isEmpty();
    }

    public boolean canBeInteger(Object value) {
        return String.valueOf(value).trim().matches("-?\\d+");
    }

    public boolean canBeDouble(Object value) {
        return String.valueOf(value).trim().matches("-?\\d+(\\.\\d*)?");
    }

    public boolean canBeNumber(Object value) {
        if (value == null) {
            return false;
        }
        return this.canBeInteger(value) || this.canBeDouble(value);
    }

    public boolean isMap(Object value) {
        return value instanceof Map;
    }

    public Map<String, Object> asMap(Object value) {
        return (Map)value;
    }
}

