/*
 * Decompiled with CFR 0.152.
 */
package liqp;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import liqp.TemplateContext;
import liqp.TemplateParser;
import liqp.exceptions.LiquidException;
import liqp.nodes.LNode;
import liqp.org.antlr.v4.runtime.BaseErrorListener;
import liqp.org.antlr.v4.runtime.CharStream;
import liqp.org.antlr.v4.runtime.CommonTokenStream;
import liqp.org.antlr.v4.runtime.RecognitionException;
import liqp.org.antlr.v4.runtime.Recognizer;
import liqp.org.antlr.v4.runtime.atn.ParserATNSimulator;
import liqp.org.antlr.v4.runtime.atn.PredictionMode;
import liqp.org.antlr.v4.runtime.tree.ParseTree;
import liqp.parser.Inspectable;
import liqp.parser.LiquidSupport;
import liqp.parser.v4.NodeVisitor;
import liqp.spi.BasicTypesSupport;
import liqp.spi.SPIHelper;
import liquid.parser.v4.LiquidLexer;
import liquid.parser.v4.LiquidParser;

public class Template {
    private final ParseTree root;
    private final long templateSize;
    private final Path sourceLocation;
    private TemplateContext templateContext = null;
    private ContextHolder contextHolder;
    private final TemplateParser templateParser;

    Template(TemplateParser templateParser, CharStream stream, Path location) {
        this.templateParser = templateParser;
        Set<String> blockNames = this.templateParser.insertions.getBlockNames();
        Set<String> tagNames = this.templateParser.insertions.getTagNames();
        this.templateSize = stream.size();
        LiquidLexer lexer = new LiquidLexer(stream, this.templateParser.isStripSpacesAroundTags(), this.templateParser.isStripSingleLine(), blockNames, tagNames);
        this.sourceLocation = location;
        try {
            this.root = this.parse(lexer);
        }
        catch (LiquidException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("could not parse input: " + stream.getSourceName(), e);
        }
    }

    private ParseTree parse(LiquidLexer lexer) {
        lexer.removeErrorListeners();
        lexer.addErrorListener(new BaseErrorListener(){

            @Override
            public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
                throw new LiquidException(String.format("lexer error \"%s\" on line %s, index %s", msg, line, charPositionInLine), line, charPositionInLine, e);
            }
        });
        CommonTokenStream tokens = new CommonTokenStream(lexer);
        LiquidParser parser = new LiquidParser(tokens, this.templateParser.liquidStyleInclude, this.templateParser.evaluateInOutputTag, this.templateParser.errorMode);
        parser.removeErrorListeners();
        parser.addErrorListener(new BaseErrorListener(){

            @Override
            public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
                throw new LiquidException(String.format("parser error \"%s\" on line %s, index %s", msg, line, charPositionInLine), line, charPositionInLine, e);
            }
        });
        ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.SLL);
        try {
            return parser.parse();
        }
        catch (Exception e) {
            tokens.seek(0);
            parser.reset();
            ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.LL);
            return parser.parse();
        }
    }

    public ParseTree getParseTree() {
        return this.root;
    }

    public Template withContextHolder(ContextHolder holder) {
        this.contextHolder = holder;
        return this;
    }

    public List<Exception> errors() {
        return this.templateContext == null ? new ArrayList() : this.templateContext.errors();
    }

    public String render(String jsonMap) {
        return this.renderToObject(jsonMap).toString();
    }

    public Object renderToObject(String jsonMap) {
        Map map;
        try {
            map = (Map)this.templateParser.mapper.readValue(jsonMap, HashMap.class);
        }
        catch (Exception e) {
            throw new RuntimeException("invalid json map: '" + jsonMap + "'", e);
        }
        return this.renderToObject(map);
    }

    public String render() {
        return this.renderToObject().toString();
    }

    public Object renderToObject() {
        return this.renderToObject(new HashMap<String, Object>());
    }

    public String render(Inspectable object) {
        return this.renderToObject(object).toString();
    }

    public Object renderToObject(Inspectable object) {
        return this.renderObjectToObject(object);
    }

    public String renderObject(Object obj) {
        return this.renderObjectToObject(obj).toString();
    }

    private Object renderObjectToObject(Object obj) {
        LiquidSupport evaluated = TemplateParser.evaluate(this.getTemplateParser().getMapper(), obj);
        Map<String, Object> map = evaluated.toLiquid();
        return this.renderToObject(map);
    }

    public String render(String key, Object value, Object ... keyValues) {
        return this.renderToObject(key, value, keyValues).toString();
    }

    private Object renderToObject(String key, Object value, Object ... keyValues) {
        return this.renderToObject(false, key, value, keyValues);
    }

    public String render(boolean convertValueToMap, String key, Object value, Object ... keyValues) {
        return this.renderToObject(convertValueToMap, key, value, keyValues).toString();
    }

    private Object renderToObject(boolean convertValueToMap, String key, Object value, Object ... keyValues) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        this.putStringKey(convertValueToMap, key, value, map);
        for (int i = 0; i < keyValues.length - 1; i += 2) {
            key = String.valueOf(keyValues[i]);
            value = keyValues[i + 1];
            this.putStringKey(convertValueToMap, key, value, map);
        }
        return this.renderToObject(map);
    }

    public String render(Map<String, Object> variables) {
        return this.renderToObject(variables).toString();
    }

    public Object renderToObject(Map<String, Object> variables) {
        if (this.templateParser.isRenderTimeLimited().booleanValue()) {
            return this.renderToObject(variables, Executors.newSingleThreadExecutor(), true);
        }
        long maxTemplateSizeBytes = this.templateParser.getLimitMaxTemplateSizeBytes();
        if (this.templateSize > maxTemplateSizeBytes) {
            throw new RuntimeException("template exceeds " + maxTemplateSizeBytes + " bytes");
        }
        return this.renderToObjectUnguarded(variables);
    }

    public String render(Map<String, Object> variables, ExecutorService executorService, boolean shutdown) {
        return this.renderToObject(variables, executorService, shutdown).toString();
    }

    private Object renderToObject(Map<String, Object> variables, ExecutorService executorService, boolean shutdown) {
        long maxTemplateSizeBytes = this.templateParser.getLimitMaxTemplateSizeBytes();
        if (this.templateSize > maxTemplateSizeBytes) {
            throw new RuntimeException("template exceeds " + maxTemplateSizeBytes + " bytes");
        }
        long maxRenderTimeMillis = this.templateParser.getLimitMaxRenderTimeMillis();
        try {
            Future<Object> future = executorService.submit(() -> this.renderToObjectUnguarded(variables));
            Object object = future.get(maxRenderTimeMillis, TimeUnit.MILLISECONDS);
            return object;
        }
        catch (TimeoutException e) {
            throw new RuntimeException("exceeded the max amount of time (" + maxRenderTimeMillis + " ms.)");
        }
        catch (Throwable t) {
            throw new RuntimeException("Oops, something unexpected happened: ", t);
        }
        finally {
            if (shutdown) {
                executorService.shutdown();
            }
        }
    }

    public String renderUnguarded(Map<String, Object> variables) {
        return this.renderToObjectUnguarded(variables).toString();
    }

    public Object renderToObjectUnguarded(Map<String, Object> variables) {
        return this.renderToObjectUnguarded(variables, null, true);
    }

    public String renderUnguarded(Map<String, Object> variables, TemplateContext parent, boolean doClearThreadLocal) {
        return this.renderToObjectUnguarded(variables, parent, doClearThreadLocal).toString();
    }

    private TemplateContext newRootContext(Map<String, Object> variables) {
        TemplateContext context = new TemplateContext(this.templateParser, variables);
        Consumer<Map<String, Object>> configurator = context.getParser().getEnvironmentMapConfigurator();
        if (configurator != null) {
            configurator.accept(context.getEnvironmentMap());
        }
        return context;
    }

    public Object renderToObjectUnguarded(Map<String, Object> variables, TemplateContext parent, boolean doClearThreadLocal) {
        if (doClearThreadLocal) {
            BasicTypesSupport.clearReferences();
        }
        variables = this.templateParser.evaluate(this.templateParser.mapper, variables);
        NodeVisitor visitor = new NodeVisitor(this.templateParser.insertions, this.templateParser.filters, this.templateParser.liquidStyleInclude);
        try {
            LNode node = (LNode)visitor.visit(this.root);
            this.templateContext = parent == null ? this.newRootContext(variables) : parent.newChildContext(variables);
            this.setRootFolderRegistry(this.templateContext, this.sourceLocation);
            if (this.contextHolder != null) {
                this.contextHolder.setContext(this.templateContext);
            }
            Object rendered = node.render(this.templateContext);
            return this.templateContext.getParser().getRenderTransformer().transformObject(this.templateContext, rendered);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw e;
            }
            throw new RuntimeException(e);
        }
    }

    private void setRootFolderRegistry(TemplateContext templateContext, Path sourceLocation) {
        if (sourceLocation != null) {
            Object registry = templateContext.getRegistry("registry_root_folder");
            registry.putIfAbsent((String)"registry_root_folder", (Path)sourceLocation.getParent());
        }
    }

    public String renderUnguarded(TemplateContext parent) {
        return this.renderToObjectUnguarded(parent).toString();
    }

    private Object renderToObjectUnguarded(TemplateContext parent) {
        return this.renderToObjectUnguarded(new HashMap<String, Object>(), parent, true);
    }

    public String toStringTree() {
        StringBuilder builder = new StringBuilder();
        this.walk(this.root, builder);
        return builder.toString();
    }

    private void walk(ParseTree tree, StringBuilder builder) {
        ArrayList<ParseTree> firstStack = new ArrayList<ParseTree>();
        firstStack.add(tree);
        ArrayList<ArrayList<ParseTree>> childListStack = new ArrayList<ArrayList<ParseTree>>();
        childListStack.add(firstStack);
        while (!childListStack.isEmpty()) {
            List childStack = (List)childListStack.get(childListStack.size() - 1);
            if (childStack.isEmpty()) {
                childListStack.remove(childListStack.size() - 1);
                continue;
            }
            tree = (ParseTree)childStack.remove(0);
            String indent = "";
            for (int i = 0; i < childListStack.size() - 1; ++i) {
                indent = indent + (((List)childListStack.get(i)).size() > 0 ? "|  " : "   ");
            }
            String tokenName = tree.getClass().getSimpleName().replaceAll("Context$", "");
            String tokenText = tree.getText().replaceAll("\\s+", " ");
            builder.append(indent).append(childStack.isEmpty() ? "'- " : "|- ").append(tokenName).append(tree.getChildCount() == 0 ? "='" + tokenText + "'" : "").append("\n");
            if (tree.getChildCount() <= 0) continue;
            childListStack.add(new ArrayList<ParseTree>(Template.children(tree)));
        }
    }

    private static List<ParseTree> children(ParseTree parent) {
        ArrayList<ParseTree> children = new ArrayList<ParseTree>();
        for (int i = 0; i < parent.getChildCount(); ++i) {
            children.add(parent.getChild(i));
        }
        return children;
    }

    private void putStringKey(boolean convertValueToMap, String key, Object value, Map<String, Object> map) {
        if (key == null) {
            throw new RuntimeException("key cannot be null");
        }
        if (convertValueToMap && value != null) {
            if ((value.getClass().isArray() || value instanceof List) && !(value instanceof Map)) {
                map.put(key, this.templateParser.mapper.convertValue(value, List.class));
            } else {
                map.put(key, this.templateParser.mapper.convertValue(value, Map.class));
            }
        } else {
            map.put(key, value);
        }
    }

    TemplateParser getTemplateParser() {
        return this.templateParser;
    }

    static {
        SPIHelper.applyCustomDateTypes();
    }

    public static class ContextHolder {
        private TemplateContext context;

        private void setContext(TemplateContext context) {
            this.context = context;
        }

        public TemplateContext getContext() {
            return this.context;
        }
    }
}

