/*
 * Decompiled with CFR 0.152.
 */
package liqp;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import liqp.RenderTransformer;
import liqp.Template;
import liqp.TemplateParser;
import liqp.exceptions.ExceededMaxIterationsException;

public class TemplateContext {
    public static final String REGISTRY_CYCLE = "cycle";
    public static final String REGISTRY_IFCHANGED = "ifchanged";
    public static final String REGISTRY_FOR = "for";
    public static final String REGISTRY_FOR_STACK = "for_stack";
    public static final String REGISTRY_ITERATION_PROTECTOR = "iteration_protector";
    public static final String REGISTRY_ROOT_FOLDER = "registry_root_folder";
    protected TemplateContext parent;
    private final TemplateParser parser;
    private Map<String, Object> variables;
    private Map<String, Object> environmentMap;
    private Map<String, Object> registry;
    private final List<Exception> errors;
    private final Template template;

    public TemplateContext() {
        this(TemplateParser.DEFAULT, new LinkedHashMap<String, Object>());
    }

    public TemplateContext(Map<String, Object> variables) {
        this(new TemplateParser.Builder().build(), variables);
    }

    public TemplateContext(TemplateParser parser, Map<String, Object> variables) {
        this(null, parser, variables);
    }

    public TemplateContext(Template template, TemplateParser parser, Map<String, Object> variables) {
        this.template = template;
        this.parent = null;
        this.parser = parser;
        this.variables = new LinkedHashMap<String, Object>(variables);
        this.errors = new ArrayList<Exception>();
    }

    public TemplateContext(TemplateContext parent) {
        this(parent.template, parent.getParser(), new LinkedHashMap<String, Object>());
        this.parent = parent;
    }

    protected TemplateContext(Map<String, Object> variables, TemplateContext parent) {
        this(parent);
        this.variables = variables;
    }

    public TemplateParser getParser() {
        return this.parser;
    }

    public void addError(Exception exception) {
        this.errors.add(exception);
    }

    public List<Exception> errors() {
        return new ArrayList<Exception>(this.errors);
    }

    public void incrementIterations() {
        Object iteratorProtector = this.getRegistry(REGISTRY_ITERATION_PROTECTOR);
        if (!iteratorProtector.containsKey(REGISTRY_ITERATION_PROTECTOR)) {
            iteratorProtector.put((String)REGISTRY_ITERATION_PROTECTOR, 0);
        }
        int value = (Integer)iteratorProtector.get(REGISTRY_ITERATION_PROTECTOR) + 1;
        iteratorProtector.put((String)REGISTRY_ITERATION_PROTECTOR, value);
        this.checkForMaxIterations(value);
    }

    public boolean containsKey(String key) {
        if (this.variables.containsKey(key)) {
            return true;
        }
        if (this.parent != null) {
            return this.parent.containsKey(key);
        }
        return false;
    }

    public Object get(String key) {
        Object value = this.variables.get(key);
        if (value != null) {
            return value;
        }
        if (this.parent != null) {
            return this.parent.get(key);
        }
        return null;
    }

    public Object put(String key, Object value) {
        return this.put(key, value, false);
    }

    public Object put(String key, Object value, boolean putInRootContext) {
        if (!putInRootContext || this.parent == null) {
            return this.variables.put(key, value);
        }
        return this.parent.put(key, value, putInRootContext);
    }

    public Object remove(String key) {
        if (this.variables.containsKey(key)) {
            return this.variables.remove(key);
        }
        if (this.parent != null) {
            return this.parent.remove(key);
        }
        return null;
    }

    public Map<String, Object> getVariables() {
        return new LinkedHashMap<String, Object>(this.variables);
    }

    public Map<String, Object> getEnvironmentMap() {
        if (this.parent != null) {
            return this.parent.getEnvironmentMap();
        }
        if (this.environmentMap == null) {
            this.environmentMap = new HashMap<String, Object>();
        }
        return this.environmentMap;
    }

    public <T extends Map<String, ?>> T getRegistry(String registryName) {
        if (this.parent != null) {
            return this.parent.getRegistry(registryName);
        }
        if (!Arrays.asList(REGISTRY_CYCLE, REGISTRY_IFCHANGED, REGISTRY_FOR, REGISTRY_FOR_STACK, REGISTRY_ITERATION_PROTECTOR, REGISTRY_ROOT_FOLDER).contains(registryName)) {
            throw new RuntimeException("unknown registry type: " + registryName);
        }
        if (this.registry == null) {
            this.registry = new HashMap<String, Object>();
        }
        if (!this.registry.containsKey(registryName)) {
            this.registry.put(registryName, new HashMap());
        }
        return (T)((Map)this.registry.get(registryName));
    }

    public RenderTransformer.ObjectAppender.Controller newObjectAppender(int estimatedNumberOfAppends) {
        return this.parser.getRenderTransformer().newObjectAppender(this, estimatedNumberOfAppends);
    }

    public TemplateContext newChildContext(Map<String, Object> variablesForChild) {
        return new TemplateContext(variablesForChild, this);
    }

    public void checkForMaxIterations(int iterations) {
        int maxIterations = this.parser.getLimitMaxIterations();
        if (iterations > maxIterations) {
            throw new ExceededMaxIterationsException(maxIterations);
        }
    }

    public TemplateParser.ErrorMode getErrorMode() {
        return this.parser.getErrorMode();
    }

    public TemplateContext newChildContext() {
        return this.newChildContext(new HashMap<String, Object>());
    }

    public Path getRootFolder() {
        Object registry = this.getRegistry(REGISTRY_ROOT_FOLDER);
        return (Path)registry.get(REGISTRY_ROOT_FOLDER);
    }
}

