/*
 * Decompiled with CFR 0.152.
 */
package liqp;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import liqp.Insertion;
import liqp.Insertions;
import liqp.RenderTransformer;
import liqp.RenderTransformerDefaultImpl;
import liqp.Template;
import liqp.antlr.LocalFSNameResolver;
import liqp.antlr.NameResolver;
import liqp.blocks.Block;
import liqp.filters.Filter;
import liqp.filters.Filters;
import liqp.org.antlr.v4.runtime.CharStream;
import liqp.org.antlr.v4.runtime.CharStreams;
import liqp.parser.Flavor;
import liqp.parser.LiquidSupport;
import liqp.tags.Tag;

public class TemplateParser {
    public static final Locale DEFAULT_LOCALE = Locale.ENGLISH;
    public static final Flavor DEFAULT_FLAVOR = Flavor.LIQP;
    public static final TemplateParser DEFAULT = DEFAULT_FLAVOR.defaultParser();
    public static final TemplateParser DEFAULT_JEKYLL = Flavor.JEKYLL.defaultParser();
    public final Flavor flavor;
    public final boolean stripSpacesAroundTags;
    public final boolean stripSingleLine;
    public final ObjectMapper mapper;
    public final Insertions insertions;
    public final Filters filters;
    public final boolean evaluateInOutputTag;
    public final boolean strictTypedExpressions;
    public final ErrorMode errorMode;
    public final boolean liquidStyleInclude;
    public final boolean liquidStyleWhere;
    public final boolean strictVariables;
    public final boolean showExceptionsFromInclude;
    public final EvaluateMode evaluateMode;
    public final Locale locale;
    public final ZoneId defaultTimeZone;
    private final RenderTransformer renderTransformer;
    private final Consumer<Map<String, Object>> environmentMapConfigurator;
    public final NameResolver nameResolver;
    private final int limitMaxIterations;
    private final int limitMaxSizeRenderedString;
    private final long limitMaxRenderTimeMillis;
    private final long limitMaxTemplateSizeBytes;

    public Map<String, Object> evaluate(ObjectMapper mapper, Map<String, Object> variables) {
        if (this.evaluateMode == EvaluateMode.EAGER) {
            return LiquidSupport.LiquidSupportFromInspectable.objectToMap(mapper, variables);
        }
        return variables;
    }

    public LiquidSupport evaluate(Object variable) {
        return TemplateParser.evaluate(this.mapper, variable);
    }

    static LiquidSupport evaluate(ObjectMapper mapper, Object variable) {
        if (variable instanceof LiquidSupport) {
            return (LiquidSupport)variable;
        }
        return new LiquidSupport.LiquidSupportFromInspectable(mapper, variable);
    }

    TemplateParser(boolean strictVariables, boolean showExceptionsFromInclude, EvaluateMode evaluateMode, RenderTransformer renderTransformer, Locale locale, ZoneId defaultTimeZone, Consumer<Map<String, Object>> environmentMapConfigurator, ErrorMode errorMode, Flavor flavor, boolean stripSpacesAroundTags, boolean stripSingleLine, ObjectMapper mapper, Insertions insertions, Filters filters, boolean evaluateInOutputTag, boolean strictTypedExpressions, boolean liquidStyleInclude, Boolean liquidStyleWhere, NameResolver nameResolver, int maxIterations, int maxSizeRenderedString, long maxRenderTimeMillis, long maxTemplateSizeBytes) {
        this.flavor = flavor;
        this.stripSpacesAroundTags = stripSpacesAroundTags;
        this.stripSingleLine = stripSingleLine;
        this.mapper = mapper;
        this.insertions = insertions;
        this.filters = filters;
        this.evaluateInOutputTag = evaluateInOutputTag;
        this.strictTypedExpressions = strictTypedExpressions;
        this.errorMode = errorMode;
        this.liquidStyleInclude = liquidStyleInclude;
        this.liquidStyleWhere = liquidStyleWhere;
        this.strictVariables = strictVariables;
        this.showExceptionsFromInclude = showExceptionsFromInclude;
        this.evaluateMode = evaluateMode;
        this.renderTransformer = renderTransformer == null ? RenderTransformerDefaultImpl.INSTANCE : renderTransformer;
        this.locale = locale;
        this.defaultTimeZone = defaultTimeZone;
        this.environmentMapConfigurator = environmentMapConfigurator;
        this.nameResolver = nameResolver;
        this.limitMaxIterations = maxIterations;
        this.limitMaxSizeRenderedString = maxSizeRenderedString;
        this.limitMaxRenderTimeMillis = maxRenderTimeMillis;
        this.limitMaxTemplateSizeBytes = maxTemplateSizeBytes;
    }

    public Template parse(Path path) throws IOException {
        return new Template(this, CharStreams.fromPath(path), path.toAbsolutePath());
    }

    public Template parse(File file) throws IOException {
        Path path = file.toPath();
        return new Template(this, CharStreams.fromPath(path), path.toAbsolutePath());
    }

    public Template parse(String input) {
        return new Template(this, CharStreams.fromString(input), Paths.get(".", new String[0]).toAbsolutePath());
    }

    public Template parse(InputStream input) throws IOException {
        Path location = this.getLocationFromInputStream(input);
        return new Template(this, CharStreams.fromStream(input), Optional.ofNullable(location).orElseGet(() -> Paths.get(".", new String[0]).toAbsolutePath()));
    }

    public Template parse(Reader reader) throws IOException {
        return new Template(this, CharStreams.fromReader(reader), Paths.get(".", new String[0]).toAbsolutePath());
    }

    public Template parse(CharStream input) {
        Path location = NameResolver.getLocationFromCharStream(input);
        return new Template(this, input, Optional.ofNullable(location).orElseGet(() -> Paths.get(".", new String[0]).toAbsolutePath()));
    }

    public int getLimitMaxIterations() {
        return this.limitMaxIterations;
    }

    public int getLimitMaxSizeRenderedString() {
        return this.limitMaxSizeRenderedString;
    }

    public long getLimitMaxRenderTimeMillis() {
        return this.limitMaxRenderTimeMillis;
    }

    public long getLimitMaxTemplateSizeBytes() {
        return this.limitMaxTemplateSizeBytes;
    }

    public Boolean isRenderTimeLimited() {
        return this.limitMaxRenderTimeMillis != Long.MAX_VALUE;
    }

    public ErrorMode getErrorMode() {
        return this.errorMode;
    }

    public boolean isStripSingleLine() {
        return this.stripSingleLine;
    }

    public boolean isStripSpacesAroundTags() {
        return this.stripSpacesAroundTags;
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    public RenderTransformer getRenderTransformer() {
        return this.renderTransformer;
    }

    public Consumer<Map<String, Object>> getEnvironmentMapConfigurator() {
        return this.environmentMapConfigurator;
    }

    private Path getLocationFromInputStream(InputStream input) {
        try {
            if (input instanceof FileInputStream) {
                return Paths.get(((FileInputStream)input).getFD().toString(), new String[0]).toAbsolutePath();
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static enum EvaluateMode {
        LAZY,
        EAGER;

    }

    public static enum ErrorMode {
        STRICT,
        WARN,
        LAX;

    }

    public static class Builder {
        private Flavor flavor;
        private boolean stripSpacesAroundTags = false;
        private boolean stripSingleLine = false;
        private ObjectMapper mapper;
        private List<Insertion> insertions = new ArrayList<Insertion>();
        private List<Filter> filters = new ArrayList<Filter>();
        private Boolean evaluateInOutputTag;
        private Boolean strictTypedExpressions;
        private ErrorMode errorMode;
        private Boolean liquidStyleInclude;
        private Boolean liquidStyleWhere;
        private boolean strictVariables = false;
        private boolean showExceptionsFromInclude = true;
        private EvaluateMode evaluateMode = EvaluateMode.LAZY;
        private Locale locale = DEFAULT_LOCALE;
        private ZoneId defaultTimeZone;
        private RenderTransformer renderTransformer;
        private Consumer<Map<String, Object>> environmentMapConfigurator;
        private String snippetsFolderName;
        private Integer limitMaxIterations = Integer.MAX_VALUE;
        private Integer limitMaxSizeRenderedString = Integer.MAX_VALUE;
        private Long limitMaxRenderTimeMillis = Long.MAX_VALUE;
        private Long limitMaxTemplateSizeBytes = Long.MAX_VALUE;
        private NameResolver nameResolver;

        public Builder() {
        }

        public Builder(TemplateParser parser) {
            this.flavor = parser.flavor;
            this.stripSpacesAroundTags = parser.stripSpacesAroundTags;
            this.stripSingleLine = parser.stripSingleLine;
            this.mapper = parser.mapper;
            this.insertions = new ArrayList<Insertion>(parser.insertions.values());
            this.filters = new ArrayList<Filter>(parser.filters.values());
            this.strictVariables = parser.strictVariables;
            this.evaluateMode = parser.evaluateMode;
            this.locale = parser.locale;
            this.renderTransformer = parser.renderTransformer;
            this.environmentMapConfigurator = parser.environmentMapConfigurator;
            this.showExceptionsFromInclude = parser.showExceptionsFromInclude;
            this.limitMaxIterations = parser.limitMaxIterations;
            this.limitMaxSizeRenderedString = parser.limitMaxSizeRenderedString;
            this.limitMaxRenderTimeMillis = parser.limitMaxRenderTimeMillis;
            this.limitMaxTemplateSizeBytes = parser.limitMaxTemplateSizeBytes;
            this.evaluateInOutputTag = parser.evaluateInOutputTag;
            this.strictTypedExpressions = parser.strictTypedExpressions;
            this.liquidStyleInclude = parser.liquidStyleInclude;
            this.liquidStyleWhere = parser.liquidStyleWhere;
            this.errorMode = parser.errorMode;
            this.nameResolver = parser.nameResolver;
        }

        public Builder withFlavor(Flavor flavor) {
            this.flavor = flavor;
            return this;
        }

        public Builder withStripSpaceAroundTags(boolean stripSpacesAroundTags, boolean stripSingleLine) {
            if (stripSingleLine && !stripSpacesAroundTags) {
                throw new IllegalStateException("stripSpacesAroundTags must be true if stripSingleLine is true");
            }
            this.stripSpacesAroundTags = stripSpacesAroundTags;
            this.stripSingleLine = stripSingleLine;
            return this;
        }

        public Builder withStripSpaceAroundTags(boolean stripSpacesAroundTags) {
            return this.withStripSpaceAroundTags(stripSpacesAroundTags, false);
        }

        public Builder withStripSingleLine(boolean stripSingleLine) {
            this.stripSingleLine = stripSingleLine;
            return this;
        }

        public Builder withObjectMapper(ObjectMapper mapper) {
            this.mapper = mapper;
            return this;
        }

        public Builder withBlock(Block block) {
            this.insertions.add(block);
            return this;
        }

        public Builder withTag(Tag tag) {
            this.insertions.add(tag);
            return this;
        }

        public Builder withFilter(Filter filter) {
            this.filters.add(filter);
            return this;
        }

        public Builder withEvaluateInOutputTag(boolean evaluateInOutputTag) {
            this.evaluateInOutputTag = evaluateInOutputTag;
            return this;
        }

        public Builder withStrictTypedExpressions(boolean strictTypedExpressions) {
            this.strictTypedExpressions = strictTypedExpressions;
            return this;
        }

        public Builder withLiquidStyleInclude(boolean liquidStyleInclude) {
            this.liquidStyleInclude = liquidStyleInclude;
            return this;
        }

        public Builder withStrictVariables(boolean strictVariables) {
            this.strictVariables = strictVariables;
            return this;
        }

        public Builder withShowExceptionsFromInclude(boolean showExceptionsFromInclude) {
            this.showExceptionsFromInclude = showExceptionsFromInclude;
            return this;
        }

        public Builder withEvaluateMode(EvaluateMode evaluateMode) {
            this.evaluateMode = evaluateMode;
            return this;
        }

        public Builder withRenderTransformer(RenderTransformer renderTransformer) {
            this.renderTransformer = renderTransformer;
            return this;
        }

        public Builder withLocale(Locale locale) {
            Objects.requireNonNull(locale);
            this.locale = locale;
            return this;
        }

        public Builder withDefaultTimeZone(ZoneId defaultTimeZone) {
            this.defaultTimeZone = defaultTimeZone;
            return this;
        }

        public Builder withEnvironmentMapConfigurator(Consumer<Map<String, Object>> configurator) {
            this.environmentMapConfigurator = configurator;
            return this;
        }

        public Builder withSnippetsFolderName(String snippetsFolderName) {
            this.snippetsFolderName = snippetsFolderName;
            return this;
        }

        public Builder withNameResolver(NameResolver nameResolver) {
            this.nameResolver = nameResolver;
            return this;
        }

        public Builder withMaxIterations(int maxIterations) {
            this.limitMaxIterations = maxIterations;
            return this;
        }

        public Builder withMaxSizeRenderedString(int maxSizeRenderedString) {
            this.limitMaxSizeRenderedString = maxSizeRenderedString;
            return this;
        }

        public Builder withMaxRenderTimeMillis(long maxRenderTimeMillis) {
            this.limitMaxRenderTimeMillis = maxRenderTimeMillis;
            return this;
        }

        public Builder withMaxTemplateSizeBytes(long maxTemplateSizeBytes) {
            this.limitMaxTemplateSizeBytes = maxTemplateSizeBytes;
            return this;
        }

        public Builder withErrorMode(ErrorMode errorMode) {
            this.errorMode = errorMode;
            return this;
        }

        public TemplateParser build() {
            ErrorMode errorMode;
            Boolean liquidStyleWhere;
            Boolean liquidStyleInclude;
            Boolean strictTypedExpressions;
            Boolean evaluateInOutputTag;
            Flavor fl = this.flavor;
            if (fl == null) {
                fl = DEFAULT_FLAVOR;
            }
            if ((evaluateInOutputTag = this.evaluateInOutputTag) == null) {
                evaluateInOutputTag = fl.isEvaluateInOutputTag();
            }
            if ((strictTypedExpressions = this.strictTypedExpressions) == null) {
                strictTypedExpressions = fl.isStrictTypedExpressions();
            }
            if ((liquidStyleInclude = this.liquidStyleInclude) == null) {
                liquidStyleInclude = fl.isLiquidStyleInclude();
            }
            if ((liquidStyleWhere = this.liquidStyleWhere) == null) {
                liquidStyleWhere = fl.isLiquidStyleWhere();
            }
            if ((errorMode = this.errorMode) == null) {
                errorMode = fl.getErrorMode();
            }
            if (this.mapper == null) {
                this.mapper = new ObjectMapper();
                this.mapper.registerModule((Module)new JavaTimeModule());
                this.mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
            }
            if (this.defaultTimeZone == null) {
                this.defaultTimeZone = ZoneId.systemDefault();
            }
            Insertions allInsertions = fl.getInsertions().mergeWith(Insertions.of(this.insertions));
            Filters finalFilters = fl.getFilters().mergeWith(this.filters);
            if (this.snippetsFolderName == null) {
                this.snippetsFolderName = fl.snippetsFolderName;
            }
            if (this.nameResolver == null) {
                this.nameResolver = new LocalFSNameResolver(this.snippetsFolderName);
            }
            return new TemplateParser(this.strictVariables, this.showExceptionsFromInclude, this.evaluateMode, this.renderTransformer, this.locale, this.defaultTimeZone, this.environmentMapConfigurator, errorMode, fl, this.stripSpacesAroundTags, this.stripSingleLine, this.mapper, allInsertions, finalFilters, evaluateInOutputTag, strictTypedExpressions, liquidStyleInclude, liquidStyleWhere, this.nameResolver, this.limitMaxIterations, this.limitMaxSizeRenderedString, this.limitMaxRenderTimeMillis, this.limitMaxTemplateSizeBytes);
        }
    }
}

