/*
 * Decompiled with CFR 0.152.
 */
package liqp.blocks;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import liqp.RenderTransformer;
import liqp.TemplateContext;
import liqp.blocks.Block;
import liqp.nodes.LNode;
import liqp.parser.LiquidSupport;

public class Tablerow
extends Block {
    private static final String COLS = "cols";
    private static final String LIMIT = "limit";
    private static final String OFFSET = "offset";
    private static final String TABLEROWLOOP = "tablerowloop";
    private static final String LENGTH = "length";
    private static final String INDEX = "index";
    private static final String INDEX0 = "index0";
    private static final String RINDEX = "rindex";
    private static final String RINDEX0 = "rindex0";
    private static final String FIRST = "first";
    private static final String LAST = "last";
    private static final String COL = "col";
    private static final String COL0 = "col0";
    private static final String COL_FIRST = "col_first";
    private static final String COL_LAST = "col_last";
    private static final String ROW = "row";

    @Override
    public Object render(TemplateContext context, LNode ... nodes) {
        String valueName = super.asString(nodes[0].render(context), context);
        Object[] collection = super.asArray(nodes[1].render(context), context);
        LNode block = nodes[2];
        Map<String, Integer> attributes = this.getAttributes(collection, 3, context, nodes);
        int cols = attributes.get(COLS);
        int limit = attributes.get(LIMIT);
        int offset = attributes.get(OFFSET);
        if (offset != 0) {
            collection = collection.length > 0 && offset < collection.length ? Arrays.copyOfRange(collection, offset, collection.length) : new Object[]{};
        }
        TemplateContext nestedContext = context.newChildContext();
        int total = Math.min(collection.length, limit);
        TablerowloopDrop tablerowloopDrop = new TablerowloopDrop(total, cols);
        nestedContext.put(TABLEROWLOOP, tablerowloopDrop);
        RenderTransformer.ObjectAppender.Controller builder = context.newObjectAppender(total * 5);
        if (total == 0) {
            builder.append("<tr class=\"row1\">\n</tr>\n");
        } else {
            int i = 0;
            int c = 1;
            int r = 0;
            while (i < total) {
                context.incrementIterations();
                nestedContext.put(valueName, collection[i]);
                if (c == 1) {
                    builder.append("<tr class=\"row");
                    builder.append(++r);
                    builder.append("\">");
                    builder.append(r == 1 ? "\n" : "");
                }
                builder.append("<td class=\"col");
                builder.append(c);
                builder.append("\">");
                builder.append(super.asAppendableObject(block.render(nestedContext), context));
                builder.append("</td>");
                if (c == cols || i == total - 1) {
                    builder.append("</tr>\n");
                    c = 0;
                }
                tablerowloopDrop.increment();
                ++i;
                ++c;
            }
        }
        nestedContext.remove(TABLEROWLOOP);
        nestedContext.remove(valueName);
        return builder.getResult();
    }

    private Map<String, Integer> getAttributes(Object[] collection, int fromIndex, TemplateContext context, LNode ... tokens) {
        HashMap<String, Integer> attributes = new HashMap<String, Integer>();
        attributes.put(COLS, collection.length);
        attributes.put(LIMIT, Integer.MAX_VALUE);
        attributes.put(OFFSET, 0);
        for (int i = fromIndex; i < tokens.length; ++i) {
            Object[] attribute = super.asArray(tokens[i].render(context), context);
            try {
                attributes.put(super.asString(attribute[0], context), super.asNumber(attribute[1]).intValue());
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return attributes;
    }

    public static class TablerowloopDrop
    implements LiquidSupport {
        private final long length;
        private final long cols;
        private long row;
        private long col;
        private long index;
        private Map<String, Object> tablerowloopContext = new HashMap<String, Object>();

        TablerowloopDrop(long length, long cols) {
            this.length = length;
            this.cols = cols;
            this.row = 1L;
            this.col = 1L;
            this.index = 0L;
        }

        @Override
        public Map<String, Object> toLiquid() {
            this.tablerowloopContext.put(Tablerow.LENGTH, this.length);
            this.tablerowloopContext.put(Tablerow.INDEX0, this.index);
            this.tablerowloopContext.put(Tablerow.INDEX, this.index + 1L);
            this.tablerowloopContext.put(Tablerow.RINDEX0, this.length - this.index - 1L);
            this.tablerowloopContext.put(Tablerow.RINDEX, this.length - this.index);
            this.tablerowloopContext.put(Tablerow.FIRST, this.index == 0L);
            this.tablerowloopContext.put(Tablerow.LAST, this.index == this.length - 1L);
            this.tablerowloopContext.put(Tablerow.COL0, this.col - 1L);
            this.tablerowloopContext.put(Tablerow.COL, this.col);
            this.tablerowloopContext.put(Tablerow.COL_FIRST, this.col == 1L);
            this.tablerowloopContext.put(Tablerow.COL_LAST, this.col == this.cols);
            this.tablerowloopContext.put(Tablerow.ROW, this.row);
            return this.tablerowloopContext;
        }

        public void increment() {
            ++this.index;
            if (this.col == this.cols) {
                this.col = 1L;
                ++this.row;
            } else {
                ++this.col;
            }
        }
    }
}

