/*
 * Decompiled with CFR 0.152.
 */
package liqp.filters;

import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.Locale;
import liqp.LValue;
import liqp.TemplateContext;
import liqp.filters.Filter;
import liqp.filters.date.CustomDateFormatRegistry;
import liqp.filters.date.CustomDateFormatSupport;
import liqp.filters.date.Parser;
import ua.co.k.strftime.StrftimeFormatter;

public class Date
extends Filter {
    protected Date() {
    }

    protected Date(CustomDateFormatSupport<?> typeSupport) {
        CustomDateFormatRegistry.add(typeSupport);
    }

    @Override
    public Object apply(Object value, TemplateContext context, Object ... params) {
        Locale locale = context.getParser().locale;
        if (this.isArray(value) && this.asArray(value, context).length == 1) {
            value = this.asArray(value, context)[0];
        }
        try {
            String valAsString = super.asString(value, context);
            TemporalAccessor compatibleDate = "now".equals(valAsString) || "today".equals(valAsString) ? ZonedDateTime.now() : (LValue.isTemporal(value) ? LValue.asTemporal(value, context) : (super.isNumber(value) ? ZonedDateTime.ofInstant(Instant.ofEpochMilli(super.asNumber(value).longValue() * 1000L), context.getParser().defaultTimeZone) : Parser.parse(valAsString, locale, context.getParser().defaultTimeZone)));
            if (compatibleDate == null) {
                return value;
            }
            String format = super.asString(super.get(0, params), context);
            if (format == null || format.trim().isEmpty()) {
                return value;
            }
            StrftimeFormatter formatter = StrftimeFormatter.ofSafePattern((String)format, (Locale)locale);
            return formatter.format((Object)compatibleDate);
        }
        catch (Exception e) {
            return value;
        }
    }

    public static void addDatePattern(String pattern) {
        if (pattern == null) {
            throw new NullPointerException("date-pattern cannot be null");
        }
        Parser.datePatterns.add(pattern);
    }

    public static void removeDatePattern(String pattern) {
        Parser.datePatterns.remove(pattern);
    }

    public static Filter withCustomDateType(CustomDateFormatSupport<?> typeSupport) {
        return new Date(typeSupport);
    }
}

