/*
 * Decompiled with CFR 0.152.
 */
package liqp.filters;

import java.util.Arrays;
import java.util.Locale;
import liqp.LValue;
import liqp.TemplateContext;

public abstract class Filter
extends LValue {
    public final String name;

    protected Filter() {
        this.name = this.getClass().getSimpleName().toLowerCase(Locale.ENGLISH);
    }

    public Filter(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Object apply(Object value, TemplateContext context, Object ... params) {
        return value;
    }

    final void checkParams(Object[] params, int expected) {
        if (params == null || params.length != expected) {
            throw new RuntimeException("Liquid error: wrong number of arguments (given " + (params == null ? 1 : params.length + 1) + " for " + (expected + 1) + ")");
        }
    }

    final void checkParams(Object[] params, int min, int max) {
        if (params == null || params.length < min || params.length > max) {
            throw new RuntimeException("Liquid error: wrong number of arguments (given " + (params == null ? 1 : params.length + 1) + " expected " + (min + 1) + ".." + (max + 1) + ")");
        }
    }

    protected Object get(int index, Object ... params) {
        if (index >= params.length) {
            throw new RuntimeException("error in filter '" + this.name + "': cannot get param index: " + index + " from: " + Arrays.toString(params));
        }
        return params[index];
    }
}

