/*
 * Decompiled with CFR 0.152.
 */
package liqp.filters;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import liqp.filters.Abs;
import liqp.filters.Absolute_Url;
import liqp.filters.Append;
import liqp.filters.At_Least;
import liqp.filters.At_Most;
import liqp.filters.Capitalize;
import liqp.filters.Ceil;
import liqp.filters.Compact;
import liqp.filters.Concat;
import liqp.filters.Date;
import liqp.filters.Default;
import liqp.filters.Divided_By;
import liqp.filters.Downcase;
import liqp.filters.Escape;
import liqp.filters.Escape_Once;
import liqp.filters.Filter;
import liqp.filters.First;
import liqp.filters.Floor;
import liqp.filters.H;
import liqp.filters.Join;
import liqp.filters.Last;
import liqp.filters.Lstrip;
import liqp.filters.Map;
import liqp.filters.Minus;
import liqp.filters.Modulo;
import liqp.filters.Newline_To_Br;
import liqp.filters.Normalize_Whitespace;
import liqp.filters.Plus;
import liqp.filters.Pop;
import liqp.filters.Prepend;
import liqp.filters.Push;
import liqp.filters.Relative_Url;
import liqp.filters.Remove;
import liqp.filters.Remove_First;
import liqp.filters.Replace;
import liqp.filters.Replace_First;
import liqp.filters.Reverse;
import liqp.filters.Round;
import liqp.filters.Rstrip;
import liqp.filters.Shift;
import liqp.filters.Size;
import liqp.filters.Slice;
import liqp.filters.Sort;
import liqp.filters.Sort_Natural;
import liqp.filters.Split;
import liqp.filters.Strip;
import liqp.filters.Strip_HTML;
import liqp.filters.Strip_Newlines;
import liqp.filters.Times;
import liqp.filters.Truncate;
import liqp.filters.Truncatewords;
import liqp.filters.Uniq;
import liqp.filters.Unshift;
import liqp.filters.Upcase;
import liqp.filters.Url_Decode;
import liqp.filters.Url_Encode;
import liqp.filters.Where;
import liqp.filters.Where_Exp;

public final class Filters {
    private final java.util.Map<String, Filter> map;
    public static final Filters EMPTY = new Filters(Collections.emptyMap());
    static Filters COMMON_FILTERS = Filters.of(new Abs(), new Absolute_Url(), new Append(), new At_Least(), new At_Most(), new Capitalize(), new Ceil(), new Compact(), new Concat(), new Date(), new Default(), new Divided_By(), new Downcase(), new Escape(), new Escape_Once(), new First(), new Floor(), new H(), new Join(), new Last(), new Lstrip(), new Map(), new Minus(), new Modulo(), new Newline_To_Br(), new Plus(), new Prepend(), new Remove(), new Remove_First(), new Replace(), new Replace_First(), new Reverse(), new Round(), new Rstrip(), new Size(), new Slice(), new Sort(), new Sort_Natural(), new Split(), new Strip(), new Strip_HTML(), new Strip_Newlines(), new Times(), new Truncate(), new Truncatewords(), new Uniq(), new Upcase(), new Url_Decode(), new Url_Encode(), new Where());
    static Filters JEKYLL_EXTRA_FILTERS = Filters.of(new Normalize_Whitespace(), new Pop(), new Push(), new Relative_Url(), new Shift(), new Unshift(), new Where_Exp());
    public static Filters DEFAULT_FILTERS = COMMON_FILTERS;
    public static Filters JEKYLL_FILTERS = COMMON_FILTERS.mergeWith(JEKYLL_EXTRA_FILTERS);

    public static Filters of(Collection<Filter> filters) {
        if (filters.isEmpty()) {
            return EMPTY;
        }
        return new Filters(filters.stream().collect(Collectors.toMap(Filter::getName, Function.identity(), (a, b) -> b)));
    }

    public static Filters of(java.util.Map<String, Filter> filters) {
        if (filters.isEmpty()) {
            return EMPTY;
        }
        return new Filters(filters);
    }

    public static Filters of(Filter ... filters) {
        return Filters.of(Arrays.asList(filters));
    }

    private Filters(java.util.Map<String, Filter> filters) {
        Objects.requireNonNull(filters);
        this.map = Collections.unmodifiableMap(new HashMap<String, Filter>(filters));
    }

    public java.util.Map<String, Filter> getMap() {
        return this.map;
    }

    public Filters mergeWith(Filters other) {
        Objects.requireNonNull(other);
        if (other == this || other.map.isEmpty()) {
            return this;
        }
        if (this.map.isEmpty()) {
            return other;
        }
        HashMap<String, Filter> newMap = new HashMap<String, Filter>(this.map);
        newMap.putAll(other.map);
        return new Filters(newMap);
    }

    public Filters mergeWith(List<Filter> other) {
        Objects.requireNonNull(other);
        if (other.isEmpty()) {
            return this;
        }
        if (this.map.isEmpty()) {
            return Filters.of(other);
        }
        HashMap<String, Filter> newMap = new HashMap<String, Filter>(this.map);
        newMap.putAll(Filters.of(other).map);
        return new Filters(newMap);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Filters)) {
            return false;
        }
        return ((Filters)obj).map.equals(this.map);
    }

    public String toString() {
        if (this.map.isEmpty()) {
            return this.getClass().getName() + ".EMPTY";
        }
        return super.toString() + this.map;
    }

    public Filter get(String name) {
        return this.map.get(name);
    }

    public Collection<Filter> values() {
        return Collections.unmodifiableCollection(this.map.values());
    }
}

