/*
 * Decompiled with CFR 0.152.
 */
package liqp.filters;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import liqp.TemplateContext;
import liqp.filters.Filter;

public class Pop
extends Filter {
    @Override
    public Object apply(Object value, TemplateContext context, Object ... params) {
        int numPop;
        if (!super.isArray(value)) {
            return value;
        }
        switch (params.length) {
            case 0: {
                numPop = 1;
                break;
            }
            case 1: {
                numPop = this.asNumber(params[0]).intValue();
                if (numPop >= 0) break;
                throw new RuntimeException("negative pop value");
            }
            default: {
                throw new RuntimeException("pop supports up to 1 parameter");
            }
        }
        List<?> list = this.asList(value, context);
        int remainingSize = list.size() - numPop;
        if (remainingSize <= 0) {
            return Collections.emptyList();
        }
        list = new ArrayList(list.subList(0, remainingSize));
        return list;
    }
}

