/*
 * Decompiled with CFR 0.152.
 */
package liqp.filters;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import liqp.PlainBigDecimal;
import liqp.TemplateContext;
import liqp.filters.Filter;

public class Round
extends Filter {
    @Override
    public Object apply(Object value, TemplateContext context, Object ... params) {
        if (!super.canBeDouble(value)) {
            return 0;
        }
        StringBuilder formatBuilder = new StringBuilder("0");
        Double number = super.asNumber(value).doubleValue();
        Long round = 0L;
        if (params.length > 0 && super.canBeDouble(params[0])) {
            round = super.asNumber(params[0]).longValue();
        }
        if (round > 0L) {
            formatBuilder.append(".");
            int i = 0;
            while ((long)i < round) {
                formatBuilder.append("0");
                ++i;
            }
        }
        DecimalFormat formatter = new DecimalFormat(formatBuilder.toString());
        formatter.setRoundingMode(RoundingMode.HALF_UP);
        return new PlainBigDecimal(formatter.format(number));
    }
}

