/*
 * Decompiled with CFR 0.152.
 */
package liqp.filters;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import liqp.TemplateContext;
import liqp.filters.Filter;
import liqp.parser.Inspectable;
import liqp.parser.LiquidSupport;

public class Sort
extends Filter {
    @Override
    public Object apply(Object value, TemplateContext context, Object ... params) {
        List<Object> list;
        if (value == null) {
            return "";
        }
        String property = params.length == 0 ? null : super.asString(params[0], context);
        boolean wasMap = false;
        if (value instanceof Map) {
            if (((Map)((Object)value)).isEmpty()) {
                return value;
            }
            list = new ArrayList();
            for (Map.Entry en : ((Map)((Object)value)).entrySet()) {
                list.add(new ComparableMapEntry(en));
            }
            value = list;
            wasMap = true;
        } else if (value instanceof Collection && ((Collection)value).isEmpty()) {
            return value;
        }
        if (!super.isArray(value)) {
            throw new RuntimeException("cannot sort: " + value + "; type:" + (value == null ? "null" : value.getClass()));
        }
        Object[] array = super.asArray(value, context);
        list = this.asComparableList(context, array, property);
        Collections.sort(list);
        if (wasMap) {
            LinkedHashMap map = new LinkedHashMap();
            for (ComparableMapEntry comparableMapEntry : list) {
                map.put(comparableMapEntry.getKey(), comparableMapEntry.getValue());
            }
            return map;
        }
        return property == null ? list.toArray(new Comparable[list.size()]) : list.toArray(new SortableMap[list.size()]);
    }

    /*
     * WARNING - void declaration
     */
    private List<Comparable<Object>> asComparableList(TemplateContext context, Object[] array, String property) {
        ArrayList<Comparable<Object>> list = new ArrayList<Comparable<Object>>();
        for (Object object : array) {
            void var8_8;
            if (property != null && object instanceof Inspectable) {
                LiquidSupport evaluated = context.getParser().evaluate(object);
                Map<String, Object> map = evaluated.toLiquid();
            }
            if (var8_8 instanceof Map && property != null) {
                list.add(new SortableMap((Map)var8_8, property));
                continue;
            }
            list.add((Comparable)var8_8);
        }
        return list;
    }

    private static final class ComparableMapEntry<K, V>
    implements Map.Entry<K, V>,
    Comparable<Map.Entry<K, V>> {
        private final Map.Entry<K, V> entry;

        ComparableMapEntry(Map.Entry<K, V> entry) {
            this.entry = entry;
        }

        @Override
        public K getKey() {
            return this.entry.getKey();
        }

        @Override
        public V getValue() {
            return this.entry.getValue();
        }

        @Override
        public V setValue(V value) {
            return this.entry.setValue(value);
        }

        @Override
        public int compareTo(Map.Entry<K, V> o) {
            return ((Comparable)this.getKey()).compareTo(o.getKey());
        }

        public String toString() {
            return this.entry.toString();
        }
    }

    static class SortableMap
    extends HashMap<String, Comparable<Object>>
    implements Comparable<Object> {
        private static final long serialVersionUID = 1L;
        final String property;

        SortableMap(Map<String, Comparable<Object>> map, String property) {
            super.putAll(map);
            this.property = property;
        }

        @Override
        public int compareTo(Object that) {
            Comparable thisValue = (Comparable)this.get(this.property);
            Object thatValue = that instanceof SortableMap ? ((SortableMap)that).get(this.property) : that;
            if (thisValue == null || thatValue == null) {
                throw new RuntimeException("Liquid error: comparison of Hash with Hash failed");
            }
            return thisValue.compareTo(thatValue);
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder();
            for (Map.Entry entry : super.entrySet()) {
                builder.append(entry.getKey()).append(entry.getValue());
            }
            return builder.toString();
        }
    }
}

