/*
 * Decompiled with CFR 0.152.
 */
package liqp.filters;

import java.util.ArrayList;
import java.util.Collections;
import liqp.Template;
import liqp.TemplateContext;
import liqp.TemplateParser;
import liqp.filters.Filter;
import liqp.parser.Inspectable;
import liqp.parser.LiquidSupport;

public class Where_Exp
extends Filter {
    public Where_Exp() {
        super("where_exp");
    }

    @Override
    public Object apply(Object value, TemplateContext context, Object ... params) {
        Object[] items = null;
        if (this.isArray(value)) {
            items = this.asArray(value, context);
        }
        if (items == null && value instanceof Inspectable) {
            LiquidSupport evaluated = context.getParser().evaluate(value);
            value = evaluated.toLiquid();
        }
        if (this.isMap(value)) {
            items = this.asMap(value).values().toArray();
        }
        if (items == null) {
            return value;
        }
        String varName = this.asString(params[0], context);
        String strExpression = this.asString(params[1], context);
        Template expression = new TemplateParser.Builder(context.getParser()).withEvaluateInOutputTag(true).build().parse("{{ " + strExpression + " }}");
        ArrayList<Object> res = new ArrayList<Object>();
        for (Object item : items) {
            if (!this.matchCondition(context, item, varName, expression)) continue;
            res.add(item);
        }
        return res;
    }

    private boolean matchCondition(TemplateContext context, Object item, String varName, Template expression) {
        String res = expression.renderUnguarded(Collections.singletonMap(varName, item), context, false);
        return "true".equals(res);
    }
}

