/*
 * Decompiled with CFR 0.152.
 */
package liqp.filters.date;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQueries;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class Parser {
    public static List<String> datePatterns = new ArrayList<String>();

    public static ZonedDateTime parse(String str, Locale locale, ZoneId defaultZone) {
        for (String pattern : datePatterns) {
            try {
                DateTimeFormatter timeFormatter = new DateTimeFormatterBuilder().parseCaseInsensitive().appendPattern(pattern).toFormatter(locale);
                TemporalAccessor temporalAccessor = timeFormatter.parse(str);
                return Parser.getZonedDateTimeFromTemporalAccessor(temporalAccessor, defaultZone);
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    public static ZonedDateTime getZonedDateTimeFromTemporalAccessor(TemporalAccessor temporal, ZoneId defaultZone) {
        TemporalField[] copyThese;
        if (temporal == null) {
            return ZonedDateTime.now(defaultZone);
        }
        if (temporal instanceof ZonedDateTime) {
            return (ZonedDateTime)temporal;
        }
        if (temporal instanceof Instant) {
            return ZonedDateTime.ofInstant((Instant)temporal, defaultZone);
        }
        ZoneId zoneId = temporal.query(TemporalQueries.zone());
        if (zoneId == null) {
            LocalDate date = temporal.query(TemporalQueries.localDate());
            LocalTime time = temporal.query(TemporalQueries.localTime());
            if (date == null) {
                date = LocalDate.now(defaultZone);
            }
            if (time == null) {
                time = LocalTime.now(defaultZone);
            }
            return ZonedDateTime.of(date, time, defaultZone);
        }
        LocalDateTime now = LocalDateTime.now(zoneId);
        for (TemporalField tf : copyThese = new TemporalField[]{ChronoField.YEAR, ChronoField.MONTH_OF_YEAR, ChronoField.DAY_OF_MONTH, ChronoField.HOUR_OF_DAY, ChronoField.MINUTE_OF_HOUR, ChronoField.SECOND_OF_MINUTE, ChronoField.NANO_OF_SECOND}) {
            if (!temporal.isSupported(tf)) continue;
            now = now.with(tf, temporal.get(tf));
        }
        return now.atZone(zoneId);
    }

    static {
        datePatterns.add("EEE MMM dd hh:mm:ss yyyy");
        datePatterns.add("EEE MMM dd hh:mm yyyy");
        datePatterns.add("yyyy-MM-dd");
        datePatterns.add("dd-MM-yyyy");
        datePatterns.add("yyyy-MM-dd HH:mm");
        datePatterns.add("yyyy-MM-dd HH:mm X");
        datePatterns.add("yyyy-MM-dd HH:mm Z");
        datePatterns.add("yyyy-MM-dd HH:mm z");
        datePatterns.add("yyyy-MM-dd HH:mm'Z'");
        datePatterns.add("yyyy-MM-dd HH:mm:ss");
        datePatterns.add("yyyy-MM-dd HH:mm:ss X");
        datePatterns.add("yyyy-MM-dd HH:mm:ss Z");
        datePatterns.add("yyyy-MM-dd HH:mm:ss z");
        datePatterns.add("yyyy-MM-dd HH:mm:ss'Z'");
        datePatterns.add("yyyy-MM-dd HH:mm:ss.SSS");
        datePatterns.add("yyyy-MM-dd HH:mm:ss.SSS X");
        datePatterns.add("yyyy-MM-dd HH:mm:ss.SSS Z");
        datePatterns.add("yyyy-MM-dd HH:mm:ss.SSS z");
        datePatterns.add("yyyy-MM-dd HH:mm:ss.SSS'Z'");
        datePatterns.add("yyyy-MM-dd HH:mm:ss.SSSSSS");
        datePatterns.add("yyyy-MM-dd HH:mm:ss.SSSSSS X");
        datePatterns.add("yyyy-MM-dd HH:mm:ss.SSSSSS Z");
        datePatterns.add("yyyy-MM-dd HH:mm:ss.SSSSSS z");
        datePatterns.add("yyyy-MM-dd HH:mm:ss.SSSSSS'Z'");
        datePatterns.add("yyyy-MM-dd HH:mm:ss.SSSSSSSSS");
        datePatterns.add("yyyy-MM-dd HH:mm:ss.SSSSSSSSS X");
        datePatterns.add("yyyy-MM-dd HH:mm:ss.SSSSSSSSS Z");
        datePatterns.add("yyyy-MM-dd HH:mm:ss.SSSSSSSSS z");
        datePatterns.add("yyyy-MM-dd HH:mm:ss.SSSSSSSSS'Z'");
        datePatterns.add("yyyy-MM-dd'T'HH:mm");
        datePatterns.add("yyyy-MM-dd'T'HH:mm X");
        datePatterns.add("yyyy-MM-dd'T'HH:mm Z");
        datePatterns.add("yyyy-MM-dd'T'HH:mm z");
        datePatterns.add("yyyy-MM-dd'T'HH:mm'Z'");
        datePatterns.add("yyyy-MM-dd'T'HH:mm:ss");
        datePatterns.add("yyyy-MM-dd'T'HH:mm:ss X");
        datePatterns.add("yyyy-MM-dd'T'HH:mm:ss Z");
        datePatterns.add("yyyy-MM-dd'T'HH:mm:ss z");
        datePatterns.add("yyyy-MM-dd'T'HH:mm:ss'Z'");
        datePatterns.add("yyyy-MM-dd'T'HH:mm:ss.SSS");
        datePatterns.add("yyyy-MM-dd'T'HH:mm:ss.SSS X");
        datePatterns.add("yyyy-MM-dd'T'HH:mm:ss.SSS Z");
        datePatterns.add("yyyy-MM-dd'T'HH:mm:ss.SSS z");
        datePatterns.add("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        datePatterns.add("yyyy-MM-dd'T'HH:mm:ss.SSSSSS");
        datePatterns.add("yyyy-MM-dd'T'HH:mm:ss.SSSSSS X");
        datePatterns.add("yyyy-MM-dd'T'HH:mm:ss.SSSSSS Z");
        datePatterns.add("yyyy-MM-dd'T'HH:mm:ss.SSSSSS z");
        datePatterns.add("yyyy-MM-dd'T'HH:mm:ss.SSSSSS'Z'");
        datePatterns.add("yyyy-MM-dd'T'HH:mm:ss.SSSSSSSSS");
        datePatterns.add("yyyy-MM-dd'T'HH:mm:ss.SSSSSSSSS X");
        datePatterns.add("yyyy-MM-dd'T'HH:mm:ss.SSSSSSSSS Z");
        datePatterns.add("yyyy-MM-dd'T'HH:mm:ss.SSSSSSSSS z");
        datePatterns.add("yyyy-MM-dd'T'HH:mm:ss.SSSSSSSSS'Z'");
    }
}

