/*
 * Decompiled with CFR 0.152.
 */
package liqp.nodes;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import liqp.LValue;
import liqp.RenderTransformer;
import liqp.TemplateContext;
import liqp.nodes.LNode;

public class BlockNode
implements LNode {
    private List<LNode> children = new ArrayList<LNode>();

    public BlockNode() {
        this(false);
    }

    public BlockNode(boolean isRootBlock) {
    }

    public void add(LNode node) {
        this.children.add(node);
    }

    public List<LNode> getChildren() {
        return new ArrayList<LNode>(this.children);
    }

    @Override
    public Object render(TemplateContext context) {
        RenderTransformer.ObjectAppender.Controller builder = context.newObjectAppender(this.children.size());
        for (LNode node : this.children) {
            Object value = node.render(context);
            if (value == null) continue;
            if (value == LValue.BREAK || value == LValue.CONTINUE) {
                return value;
            }
            if (value instanceof List) {
                List list = (List)value;
                for (Object obj : list) {
                    builder.append(this.postprocess(obj, context));
                }
                continue;
            }
            if (value.getClass().isArray()) {
                Object[] array;
                for (Object obj : array = (Object[])value) {
                    builder.append(this.postprocess(obj, context));
                }
                continue;
            }
            builder.append(this.postprocess(value, context));
        }
        return builder.getResult();
    }

    private Object postprocess(Object value, TemplateContext context) {
        if (LValue.isTemporal(value)) {
            ZonedDateTime time = LValue.asRubyDate(value, context);
            return LValue.rubyDateTimeFormat.format(time);
        }
        return value;
    }
}

