/*
 * Decompiled with CFR 0.152.
 */
package liqp.nodes;

import java.math.BigDecimal;
import java.util.Optional;
import liqp.LValue;
import liqp.TemplateContext;
import liqp.nodes.LNode;

public abstract class ComparingExpressionNode
extends LValue
implements LNode {
    protected final LNode lhs;
    protected final LNode rhs;
    private final boolean relative;

    public ComparingExpressionNode(LNode lhs, LNode rhs, boolean relative) {
        this.lhs = lhs;
        this.rhs = rhs;
        this.relative = relative;
    }

    @Override
    public Object render(TemplateContext context) {
        Object a = this.lhs.render(context);
        Object b = this.rhs.render(context);
        if (ComparingExpressionNode.isTemporal(a)) {
            a = ComparingExpressionNode.asRubyDate(a, context);
        }
        if (ComparingExpressionNode.isTemporal(b)) {
            b = ComparingExpressionNode.asRubyDate(b, context);
        }
        if (a instanceof Number) {
            a = this.asStrictNumber((Number)a);
        }
        if (b instanceof Number) {
            b = this.asStrictNumber((Number)b);
        }
        boolean strictTypedExpressions = context != null && context.getParser() != null ? context.getParser().strictTypedExpressions : true;
        if (this.relative) {
            Optional<Object> common = this.relativeCompareCommonRules(a, b, strictTypedExpressions);
            if (common.isPresent()) {
                return common.get();
            }
            if (!strictTypedExpressions) {
                if (a instanceof Boolean) {
                    a = this.booleanToNumber((Boolean)a);
                }
                if (b instanceof Boolean) {
                    b = this.booleanToNumber((Boolean)b);
                }
                if (a == null) {
                    a = BigDecimal.ZERO;
                }
                if (b == null) {
                    b = BigDecimal.ZERO;
                }
            }
        }
        if (!strictTypedExpressions && (a instanceof Number && this.canBeNumber(b) || b instanceof Number && this.canBeNumber(a))) {
            a = this.asStrictNumber(a);
            b = this.asStrictNumber(b);
        }
        return this.doCompare(a, b, strictTypedExpressions);
    }

    private Object booleanToNumber(Boolean a) {
        if (Boolean.TRUE.equals(a)) {
            return BigDecimal.ONE;
        }
        return BigDecimal.ZERO;
    }

    abstract Object doCompare(Object var1, Object var2, boolean var3);

    protected Optional<Object> relativeCompareCommonRules(Object a, Object b, boolean strictTypedExpressions) {
        if (strictTypedExpressions) {
            if (a instanceof Boolean || b instanceof Boolean) {
                return Optional.of(false);
            }
            if (a == null || b == null) {
                return Optional.of(false);
            }
        }
        return Optional.empty();
    }
}

