/*
 * Decompiled with CFR 0.152.
 */
package liqp.nodes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import liqp.LValue;
import liqp.PlainBigDecimal;
import liqp.TemplateContext;
import liqp.nodes.LNode;
import liqp.parser.Inspectable;
import liqp.parser.LiquidSupport;

public class ContainsNode
extends LValue
implements LNode {
    private LNode lhs;
    private LNode rhs;

    public ContainsNode(LNode lhs, LNode rhs) {
        this.lhs = lhs;
        this.rhs = rhs;
    }

    @Override
    public Object render(TemplateContext context) {
        Object[] collection = this.lhs.render(context);
        Object needle = this.rhs.render(context);
        if (collection instanceof Inspectable) {
            LiquidSupport evaluated = context.getParser().evaluate(collection);
            collection = evaluated.toLiquid();
        }
        if (this.isMap(collection)) {
            collection = this.asMap(collection).keySet().toArray();
        }
        if (super.isArray(collection)) {
            Object[] array = super.asArray(collection, context);
            List<Object> finalCollection = this.toSingleNumberType(Arrays.asList(array));
            needle = this.toSingleNumberType(needle);
            return finalCollection.contains(needle);
        }
        if (super.isString(collection)) {
            return super.asString(collection, context).contains(super.asString(needle, context));
        }
        return false;
    }

    private Object toSingleNumberType(Object needle) {
        if (needle instanceof Number) {
            needle = LValue.asFormattedNumber(new PlainBigDecimal(needle.toString()));
        }
        return needle;
    }

    private List<Object> toSingleNumberType(List<Object> asList) {
        ArrayList<Object> res = new ArrayList<Object>(asList.size());
        for (Object item : asList) {
            if (item instanceof Number) {
                res.add(LValue.asFormattedNumber(new PlainBigDecimal(item.toString())));
                continue;
            }
            res.add(item);
        }
        return res;
    }
}

