/*
 * Decompiled with CFR 0.152.
 */
package liqp.nodes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import liqp.TemplateContext;
import liqp.TemplateParser;
import liqp.exceptions.VariableNotExistException;
import liqp.nodes.LNode;
import liqp.parser.Inspectable;
import liqp.parser.LiquidSupport;

public class LookupNode
implements LNode {
    private final String id;
    private final List<Indexable> indexes;

    public LookupNode(String id) {
        this.id = id;
        this.indexes = new ArrayList<Indexable>();
    }

    public void add(Indexable indexable) {
        this.indexes.add(indexable);
    }

    @Override
    public Object render(TemplateContext context) {
        Object environmentMap;
        Object value = null;
        String realId = this.id.startsWith("@") ? String.valueOf(context.get(this.id.substring(1))) : this.id;
        if (context.containsKey(realId)) {
            value = context.get(realId);
        }
        if (value == null && (environmentMap = context.getEnvironmentMap()).containsKey(realId)) {
            value = environmentMap.get(realId);
        }
        for (Indexable index : this.indexes) {
            value = index.get(value, context);
        }
        if (value == null && context.getParser().strictVariables) {
            VariableNotExistException e = new VariableNotExistException(this.getVariableName());
            context.addError(e);
            if (context.getErrorMode() == TemplateParser.ErrorMode.STRICT) {
                throw e;
            }
        }
        return value;
    }

    private String getVariableName() {
        StringBuilder variableFullName = new StringBuilder(this.id);
        for (Indexable index : this.indexes) {
            variableFullName.append(index.toString());
        }
        return variableFullName.toString();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.id);
        for (Indexable index : this.indexes) {
            builder.append(index.toString());
        }
        return builder.toString();
    }

    public static interface Indexable {
        public Object get(Object var1, TemplateContext var2);
    }

    public static class Index
    implements Indexable {
        private final LNode expression;
        private final String text;
        private Object key = null;

        public Index(LNode expression, String text) {
            this.expression = expression;
            this.text = text;
        }

        @Override
        public Object get(Object value, TemplateContext context) {
            if (value == null) {
                return null;
            }
            this.key = this.expression.render(context);
            if (this.key instanceof Number) {
                int index = ((Number)this.key).intValue();
                if (value.getClass().isArray()) {
                    Object[] arr = (Object[])value;
                    int size = arr.length;
                    if (index >= size) {
                        return null;
                    }
                    if (index < 0 && (index = size + index) < 0) {
                        return null;
                    }
                    return arr[index];
                }
                if (value instanceof List) {
                    List list = (List)value;
                    int size = list.size();
                    if (index >= size) {
                        return null;
                    }
                    if (index < 0 && (index = size + index) < 0) {
                        return null;
                    }
                    return list.get(index);
                }
                if (value instanceof Collection) {
                    Collection coll = (Collection)value;
                    int size = coll.size();
                    if (index >= size) {
                        return null;
                    }
                    if (index < 0 && (index = size + index) < 0) {
                        return null;
                    }
                    int i = 0;
                    for (Object obj : coll) {
                        if (i == index) {
                            return obj;
                        }
                        ++i;
                    }
                    return null;
                }
                return null;
            }
            if (value.getClass().isArray() || value instanceof List) {
                return null;
            }
            String hash = String.valueOf(this.key);
            return new Hash(hash).get(value, context);
        }

        public String toString() {
            return String.format("[%s]", this.text);
        }
    }

    public static class Hash
    implements Indexable {
        private final String hash;

        public Hash(String hash) {
            this.hash = hash;
        }

        @Override
        public Object get(Object value, TemplateContext context) {
            if (value == null) {
                return null;
            }
            if (this.hash.equals("size")) {
                if (value instanceof Collection) {
                    return ((Collection)value).size();
                }
                if (value instanceof Map || value instanceof Inspectable) {
                    Map<String, Object> map;
                    if (value instanceof Inspectable) {
                        LiquidSupport evaluated = context.getParser().evaluate(value);
                        map = evaluated.toLiquid();
                    } else {
                        map = (Map<String, Object>)value;
                    }
                    return map.containsKey(this.hash) ? map.get(this.hash) : Integer.valueOf(map.size());
                }
                if (value.getClass().isArray()) {
                    return ((Object[])value).length;
                }
                if (value instanceof CharSequence) {
                    CharSequence charSequence = (CharSequence)value;
                    return charSequence.length();
                }
            } else if (this.hash.equals("first")) {
                if (value instanceof List) {
                    List list = (List)value;
                    return list.isEmpty() ? null : list.get(0);
                }
                if (value.getClass().isArray()) {
                    Object[] array = (Object[])value;
                    return array.length == 0 ? null : array[0];
                }
            } else if (this.hash.equals("last")) {
                if (value instanceof List) {
                    List list = (List)value;
                    return list.isEmpty() ? null : list.get(list.size() - 1);
                }
                if (value.getClass().isArray()) {
                    Object[] array = (Object[])value;
                    return array.length == 0 ? null : array[array.length - 1];
                }
            }
            if (value instanceof Map || value instanceof Inspectable) {
                Map<String, Object> map;
                if (value instanceof Inspectable) {
                    LiquidSupport evaluated = context.getParser().evaluate(value);
                    map = evaluated.toLiquid();
                } else {
                    map = (Map<String, Object>)value;
                }
                return map.get(this.hash);
            }
            if (value instanceof TemplateContext) {
                return ((TemplateContext)value).get(this.hash);
            }
            return null;
        }

        public String toString() {
            return String.format(".%s", this.hash);
        }
    }
}

