/*
 * Decompiled with CFR 0.152.
 */
package liqp.nodes;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import liqp.PlainBigDecimal;
import liqp.TemplateContext;
import liqp.TemplateParser;
import liqp.exceptions.LiquidException;
import liqp.nodes.FilterNode;
import liqp.nodes.LNode;
import org.jsoup.internal.StringUtil;

public class OutputNode
implements LNode {
    private LNode expression;
    private String unparsed;
    private Integer unparsedline;
    private Integer unparsedPosition;
    private List<FilterNode> filters;

    public OutputNode(LNode expression, String unparsed, Integer unparsedline, Integer unparsedPosition) {
        this.expression = expression;
        this.unparsed = unparsed;
        this.unparsedline = unparsedline;
        this.unparsedPosition = unparsedPosition;
        this.filters = new ArrayList<FilterNode>();
    }

    public void addFilter(FilterNode filter) {
        this.filters.add(filter);
    }

    @Override
    public Object render(TemplateContext context) {
        String localUnparsed;
        Object value = this.expression.render(context);
        for (FilterNode node : this.filters) {
            value = node.apply(value, context);
        }
        if (context != null && context.getParser().errorMode == TemplateParser.ErrorMode.WARN && !StringUtil.isBlank((String)(localUnparsed = this.unparsed))) {
            if (localUnparsed.length() > 30) {
                localUnparsed = localUnparsed.substring(0, 30) + "...";
            }
            if (this.unparsedline == null) {
                this.unparsedline = -1;
            }
            if (this.unparsedPosition == null) {
                this.unparsedPosition = -1;
            }
            context.addError(new LiquidException("unexpected output: " + localUnparsed, this.unparsedline, this.unparsedPosition, null));
        }
        if (value instanceof BigDecimal && !(value instanceof PlainBigDecimal)) {
            value = new PlainBigDecimal(value.toString());
        }
        return value;
    }
}

