/*
 * Decompiled with CFR 0.152.
 */
package liqp.parser;

import liqp.Insertions;
import liqp.TemplateParser;
import liqp.filters.Filters;

public enum Flavor {
    LIQUID("snippets", Filters.DEFAULT_FILTERS, Insertions.STANDARD_INSERTIONS, TemplateParser.ErrorMode.STRICT, true, true, false, true),
    JEKYLL("_includes", Filters.JEKYLL_FILTERS, Insertions.JEKYLL_INSERTIONS, TemplateParser.ErrorMode.WARN, false, false, false, true),
    LIQP("snippets", Filters.JEKYLL_FILTERS, Insertions.JEKYLL_INSERTIONS, TemplateParser.ErrorMode.STRICT, true, true, true, false);

    public final String snippetsFolderName;
    private final Filters filters;
    private final Insertions insertions;
    private final TemplateParser.ErrorMode errorMode;
    private final boolean liquidStyleInclude;
    private final boolean liquidStyleWhere;
    private final boolean evaluateInOutputTag;
    private final boolean strictTypedExpressions;
    private TemplateParser parser;

    private Flavor(String snippetsFolderName, Filters filters, Insertions insertions, TemplateParser.ErrorMode errorMode, boolean isLiquidStyleInclude, boolean isLiquidStyleWhere, boolean evaluateInOutputTag, boolean strictTypedExpressions) {
        this.snippetsFolderName = snippetsFolderName;
        this.filters = filters;
        this.insertions = insertions;
        this.errorMode = errorMode;
        this.liquidStyleInclude = isLiquidStyleInclude;
        this.liquidStyleWhere = isLiquidStyleWhere;
        this.evaluateInOutputTag = evaluateInOutputTag;
        this.strictTypedExpressions = strictTypedExpressions;
    }

    public Filters getFilters() {
        return this.filters;
    }

    public Insertions getInsertions() {
        return this.insertions;
    }

    public TemplateParser defaultParser() {
        if (this.parser == null) {
            this.parser = new TemplateParser.Builder().withFlavor(this).build();
        }
        return this.parser;
    }

    public TemplateParser.ErrorMode getErrorMode() {
        return this.errorMode;
    }

    public boolean isEvaluateInOutputTag() {
        return this.evaluateInOutputTag;
    }

    public boolean isLiquidStyleInclude() {
        return this.liquidStyleInclude;
    }

    public boolean isLiquidStyleWhere() {
        return this.liquidStyleWhere;
    }

    public boolean isStrictTypedExpressions() {
        return this.strictTypedExpressions;
    }
}

