/*
 * Decompiled with CFR 0.152.
 */
package liqp.parser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import liqp.parser.Inspectable;
import liqp.spi.BasicTypesSupport;
import liqp.spi.SPIHelper;

@JsonSerialize(using=LiquidSerializer.class)
public interface LiquidSupport
extends Inspectable {
    public Map<String, Object> toLiquid();

    public static class LiquidSupportFromInspectable
    implements LiquidSupport {
        public static final TypeReference<Map<String, Object>> MAP_TYPE_REF = new TypeReference<Map<String, Object>>(){};
        private final ObjectMapper mapper;
        private final Object variable;

        public LiquidSupportFromInspectable(ObjectMapper mapper, Object variable) {
            this.variable = variable;
            this.mapper = mapper;
        }

        public static Map<String, Object> objectToMap(ObjectMapper mapper, Object variables) {
            if (mapper == null) {
                throw new RuntimeException("ObjectMapper required here");
            }
            ObjectMapper copy = SPIHelper.applyTypeReferencing(mapper.copy());
            ObjectNode value = (ObjectNode)copy.convertValue(variables, ObjectNode.class);
            Map convertedValue = (Map)copy.convertValue((Object)value, MAP_TYPE_REF);
            LiquidSupportFromInspectable.visitMap(convertedValue);
            return convertedValue;
        }

        @Override
        public Map<String, Object> toLiquid() {
            return LiquidSupportFromInspectable.objectToMap(this.mapper, this.variable);
        }

        static void visitMap(Map<String, Object> map) {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                Object value = BasicTypesSupport.restoreObject(entry.getValue());
                LiquidSupportFromInspectable.visit(value);
                entry.setValue(value);
            }
        }

        static void visitList(List<Object> list) {
            for (int i = 0; i < list.size(); ++i) {
                Object object = list.get(i);
                Object value = BasicTypesSupport.restoreObject(object);
                LiquidSupportFromInspectable.visit(value);
                list.set(i, value);
            }
        }

        static void visit(Object object) {
            if (object instanceof Map) {
                LiquidSupportFromInspectable.visitMap((Map)object);
            }
            if (object instanceof List) {
                LiquidSupportFromInspectable.visitList((List)object);
            }
        }
    }

    public static class LiquidSerializer
    extends StdSerializer<LiquidSupport> {
        private static final long serialVersionUID = 1L;

        public LiquidSerializer() {
            this(null);
        }

        protected LiquidSerializer(Class<LiquidSupport> t) {
            super(t);
        }

        public void serialize(LiquidSupport item, JsonGenerator jsgen, SerializerProvider provider) throws IOException {
            Map<String, Object> data = item.toLiquid();
            jsgen.writeObject(data);
        }
    }
}

