/*
 * Decompiled with CFR 0.152.
 */
package liqp.spi;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import liqp.filters.date.CustomDateFormatRegistry;
import liqp.filters.date.CustomDateFormatSupport;
import liqp.spi.TypesSupport;

public abstract class BasicTypesSupport
implements TypesSupport {
    private static ThreadLocal<Map<String, Object>> local = new ThreadLocal<Map<String, Object>>(){

        @Override
        protected Map<String, Object> initialValue() {
            return new ConcurrentHashMap<String, Object>();
        }
    };

    protected <T> void registerType(SimpleModule module, Class<T> clazz) {
        module.addSerializer((JsonSerializer)new StdSerializer<T>(clazz){
            private static final long serialVersionUID = 1L;

            public void serialize(T value, JsonGenerator gen, SerializerProvider provider) throws IOException {
                gen.writeStartObject();
                gen.writeBooleanField("@supportedTypeMarker", true);
                gen.writeStringField("@ref", BasicTypesSupport.createReference(value));
                gen.writeEndObject();
            }
        });
    }

    protected void addCustomDateType(CustomDateFormatSupport<?> typeSupport) {
        if (!CustomDateFormatRegistry.isRegistered(typeSupport)) {
            CustomDateFormatRegistry.add(typeSupport);
        }
    }

    public static Object restoreObject(Object obj) {
        if (!(obj instanceof Map)) {
            return obj;
        }
        Map mapObj = (Map)obj;
        if (!Boolean.TRUE.equals(mapObj.get("@supportedTypeMarker"))) {
            return obj;
        }
        Object ref = mapObj.get("@ref");
        if (!(ref instanceof String)) {
            return obj;
        }
        return BasicTypesSupport.getByReference((String)ref);
    }

    public static String createReference(Object obj) {
        String key = Thread.currentThread().hashCode() + ":" + System.currentTimeMillis() + ":" + obj.hashCode();
        local.get().put(key, obj);
        return key;
    }

    public static Object getByReference(String key) {
        return local.get().remove(key);
    }

    public static void clearReferences() {
        local.get().clear();
    }
}

