/*
 * Decompiled with CFR 0.152.
 */
package liqp.tags;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import liqp.Template;
import liqp.TemplateContext;
import liqp.antlr.CharStreamWithLocation;
import liqp.nodes.LNode;
import liqp.tags.Tag;

public class Include
extends Tag {
    public Include() {
        super("include");
    }

    protected Include(String name) {
        super(name);
    }

    @Override
    public Object render(TemplateContext context, LNode ... nodes) {
        try {
            String includeResource = super.asString(nodes[0].render(context), context);
            CharStreamWithLocation source = this.detectSource(context, includeResource);
            Template template = context.getParser().parse(source);
            HashMap<String, Object> variables = new HashMap<String, Object>();
            if (nodes.length > 1) {
                if (context.getParser().liquidStyleInclude) {
                    Object value = nodes[1].render(context);
                    context.put(includeResource, value);
                } else {
                    HashMap includeMap = new HashMap();
                    variables.put("include", includeMap);
                    int n = nodes.length;
                    for (int i = 1; i < n; ++i) {
                        Map var = (Map)nodes[i].render(context);
                        includeMap.putAll(var);
                    }
                }
            }
            return template.renderToObjectUnguarded(variables, context, true);
        }
        catch (Exception e) {
            if (context.getParser().showExceptionsFromInclude) {
                throw new RuntimeException("problem with evaluating include", e);
            }
            return "";
        }
    }

    protected CharStreamWithLocation detectSource(TemplateContext context, String includeResource) throws IOException {
        return context.getParser().nameResolver.resolve(includeResource);
    }
}

