/*
 * Decompiled with CFR 0.152.
 */
package nl.dionsegijn.konfetti.core.models;

import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001:\u0004\u0002\u0003\u0004\u0005\u0082\u0001\u0004\u0006\u0007\b\t\u00a8\u0006\n"}, d2={"Lnl/dionsegijn/konfetti/core/models/Shape;", "", "Circle", "DrawableShape", "Rectangle", "Square", "Lnl/dionsegijn/konfetti/core/models/Shape$Circle;", "Lnl/dionsegijn/konfetti/core/models/Shape$Square;", "Lnl/dionsegijn/konfetti/core/models/Shape$Rectangle;", "Lnl/dionsegijn/konfetti/core/models/Shape$DrawableShape;", "core_release"})
public interface Shape {

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lnl/dionsegijn/konfetti/core/models/Shape$Circle;", "Lnl/dionsegijn/konfetti/core/models/Shape;", "()V", "rect", "Landroid/graphics/RectF;", "getRect", "()Landroid/graphics/RectF;", "core_release"})
    public static final class Circle
    implements Shape {
        @NotNull
        public static final Circle INSTANCE = new Circle();
        @NotNull
        private static final RectF rect = new RectF();

        private Circle() {
        }

        @NotNull
        public final RectF getRect() {
            return rect;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lnl/dionsegijn/konfetti/core/models/Shape$Square;", "Lnl/dionsegijn/konfetti/core/models/Shape;", "()V", "core_release"})
    public static final class Square
    implements Shape {
        @NotNull
        public static final Square INSTANCE = new Square();

        private Square() {
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lnl/dionsegijn/konfetti/core/models/Shape$Rectangle;", "Lnl/dionsegijn/konfetti/core/models/Shape;", "heightRatio", "", "(F)V", "getHeightRatio", "()F", "core_release"})
    public static final class Rectangle
    implements Shape {
        private final float heightRatio;

        public Rectangle(float heightRatio) {
            this.heightRatio = heightRatio;
            float f = this.heightRatio;
            if (!(0.0f <= f ? f <= 1.0f : false)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
        }

        public final float getHeightRatio() {
            return this.heightRatio;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00052\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lnl/dionsegijn/konfetti/core/models/Shape$DrawableShape;", "Lnl/dionsegijn/konfetti/core/models/Shape;", "drawable", "Landroid/graphics/drawable/Drawable;", "tint", "", "(Landroid/graphics/drawable/Drawable;Z)V", "getDrawable", "()Landroid/graphics/drawable/Drawable;", "heightRatio", "", "getHeightRatio", "()F", "getTint", "()Z", "component1", "component2", "copy", "equals", "other", "", "hashCode", "", "toString", "", "core_release"})
    public static final class DrawableShape
    implements Shape {
        @NotNull
        private final Drawable drawable;
        private final boolean tint;
        private final float heightRatio;

        public DrawableShape(@NotNull Drawable drawable, boolean tint) {
            Intrinsics.checkNotNullParameter((Object)drawable, (String)"drawable");
            this.drawable = drawable;
            this.tint = tint;
            this.heightRatio = this.drawable.getIntrinsicHeight() == -1 && this.drawable.getIntrinsicWidth() == -1 ? 1.0f : (this.drawable.getIntrinsicHeight() == -1 || this.drawable.getIntrinsicWidth() == -1 ? 0.0f : (float)this.drawable.getIntrinsicHeight() / (float)this.drawable.getIntrinsicWidth());
        }

        public /* synthetic */ DrawableShape(Drawable drawable, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                bl = true;
            }
            this(drawable, bl);
        }

        @NotNull
        public final Drawable getDrawable() {
            return this.drawable;
        }

        public final boolean getTint() {
            return this.tint;
        }

        public final float getHeightRatio() {
            return this.heightRatio;
        }

        @NotNull
        public final Drawable component1() {
            return this.drawable;
        }

        public final boolean component2() {
            return this.tint;
        }

        @NotNull
        public final DrawableShape copy(@NotNull Drawable drawable, boolean tint) {
            Intrinsics.checkNotNullParameter((Object)drawable, (String)"drawable");
            return new DrawableShape(drawable, tint);
        }

        public static /* synthetic */ DrawableShape copy$default(DrawableShape drawableShape, Drawable drawable, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                drawable = drawableShape.drawable;
            }
            if ((n & 2) != 0) {
                bl = drawableShape.tint;
            }
            return drawableShape.copy(drawable, bl);
        }

        @NotNull
        public String toString() {
            return "DrawableShape(drawable=" + this.drawable + ", tint=" + this.tint + ')';
        }

        public int hashCode() {
            int result = this.drawable.hashCode();
            int n = this.tint ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result = result * 31 + n;
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DrawableShape)) {
                return false;
            }
            DrawableShape drawableShape = (DrawableShape)other;
            if (!Intrinsics.areEqual((Object)this.drawable, (Object)drawableShape.drawable)) {
                return false;
            }
            return this.tint == drawableShape.tint;
        }
    }
}

