/*
 * Decompiled with CFR 0.152.
 */
package nl.dionsegijn.konfetti.core.emitter;

import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import nl.dionsegijn.konfetti.core.Party;
import nl.dionsegijn.konfetti.core.Position;
import nl.dionsegijn.konfetti.core.Rotation;
import nl.dionsegijn.konfetti.core.emitter.BaseEmitter;
import nl.dionsegijn.konfetti.core.emitter.Confetti;
import nl.dionsegijn.konfetti.core.emitter.EmitterConfig;
import nl.dionsegijn.konfetti.core.models.Shape;
import nl.dionsegijn.konfetti.core.models.Size;
import nl.dionsegijn.konfetti.core.models.Vector;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ&\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0016\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\u000eH\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001aH\u0002J\u0014\u0010\u001c\u001a\u00020\u001d*\u00020\u001e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\f\u0010\u001f\u001a\u00020 *\u00020\u0012H\u0002J\f\u0010!\u001a\u00020\u0005*\u00020\u0012H\u0002J\f\u0010\"\u001a\u00020#*\u00020\u0012H\u0002J\f\u0010$\u001a\u00020\u0005*\u00020%H\u0002J\f\u0010&\u001a\u00020\u0005*\u00020'H\u0002R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lnl/dionsegijn/konfetti/core/emitter/PartyEmitter;", "Lnl/dionsegijn/konfetti/core/emitter/BaseEmitter;", "emitterConfig", "Lnl/dionsegijn/konfetti/core/emitter/EmitterConfig;", "pixelDensity", "", "random", "Ljava/util/Random;", "(Lnl/dionsegijn/konfetti/core/emitter/EmitterConfig;FLjava/util/Random;)V", "createParticleMs", "elapsedTime", "particlesCreated", "", "createConfetti", "", "Lnl/dionsegijn/konfetti/core/emitter/Confetti;", "deltaTime", "party", "Lnl/dionsegijn/konfetti/core/Party;", "drawArea", "Landroid/graphics/Rect;", "createParticle", "getRandomShape", "Lnl/dionsegijn/konfetti/core/models/Shape;", "shapes", "isFinished", "", "isTimeElapsed", "get", "Lnl/dionsegijn/konfetti/core/Position$Absolute;", "Lnl/dionsegijn/konfetti/core/Position;", "getAngle", "", "getSpeed", "getVelocity", "Lnl/dionsegijn/konfetti/core/models/Vector;", "massWithVariance", "Lnl/dionsegijn/konfetti/core/models/Size;", "rotationSpeed", "Lnl/dionsegijn/konfetti/core/Rotation;", "core_release"})
public final class PartyEmitter
extends BaseEmitter {
    @NotNull
    private final EmitterConfig emitterConfig;
    private final float pixelDensity;
    @NotNull
    private final Random random;
    private int particlesCreated;
    private float elapsedTime;
    private float createParticleMs;

    public PartyEmitter(@NotNull EmitterConfig emitterConfig, float pixelDensity, @NotNull Random random) {
        Intrinsics.checkNotNullParameter((Object)emitterConfig, (String)"emitterConfig");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        this.emitterConfig = emitterConfig;
        this.pixelDensity = pixelDensity;
        this.random = random;
    }

    public /* synthetic */ PartyEmitter(EmitterConfig emitterConfig, float f, Random random, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            random = new Random();
        }
        this(emitterConfig, f, random);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Confetti> createConfetti(float deltaTime, @NotNull Party party, @NotNull Rect drawArea) {
        Intrinsics.checkNotNullParameter((Object)party, (String)"party");
        Intrinsics.checkNotNullParameter((Object)drawArea, (String)"drawArea");
        this.createParticleMs += deltaTime;
        float emittingTime = (float)this.emitterConfig.getEmittingTime() / 1000.0f;
        if (this.elapsedTime == 0.0f && deltaTime > emittingTime) {
            this.createParticleMs = emittingTime;
        }
        List particles = CollectionsKt.emptyList();
        if (this.createParticleMs >= this.emitterConfig.getAmountPerMs() && !this.isTimeElapsed()) {
            void $this$mapTo$iv$iv;
            int amount = (int)(this.createParticleMs / this.emitterConfig.getAmountPerMs());
            Iterable $this$map$iv = (Iterable)new IntRange(1, amount);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator).nextInt();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.createParticle(party, drawArea));
            }
            particles = (List)destination$iv$iv;
            this.createParticleMs %= this.emitterConfig.getAmountPerMs();
        }
        this.elapsedTime += deltaTime * (float)1000;
        return particles;
    }

    private final Confetti createParticle(Party party, Rect drawArea) {
        int n = this.particlesCreated;
        this.particlesCreated = n + 1;
        Party $this$createParticle_u24lambda_u2d2 = party;
        boolean bl = false;
        Size randomSize = $this$createParticle_u24lambda_u2d2.getSize().get(this.random.nextInt($this$createParticle_u24lambda_u2d2.getSize().size()));
        Position.Absolute $this$createParticle_u24lambda_u2d2_u24lambda_u2d1 = this.get($this$createParticle_u24lambda_u2d2.getPosition(), drawArea);
        boolean bl2 = false;
        Vector vector = new Vector($this$createParticle_u24lambda_u2d2_u24lambda_u2d1.getX(), $this$createParticle_u24lambda_u2d2_u24lambda_u2d1.getY());
        float f = (float)randomSize.getSizeInDp() * this.pixelDensity;
        float f2 = this.massWithVariance(randomSize);
        Shape shape = this.getRandomShape(party.getShapes());
        int n2 = ((Number)$this$createParticle_u24lambda_u2d2.getColors().get(this.random.nextInt($this$createParticle_u24lambda_u2d2.getColors().size()))).intValue();
        long l = $this$createParticle_u24lambda_u2d2.getTimeToLive();
        boolean bl3 = $this$createParticle_u24lambda_u2d2.getFadeOutEnabled();
        Vector vector2 = this.getVelocity($this$createParticle_u24lambda_u2d2);
        float f3 = party.getDamping();
        float f4 = this.rotationSpeed($this$createParticle_u24lambda_u2d2.getRotation()) * party.getRotation().getMultiplier2D();
        float f5 = this.rotationSpeed($this$createParticle_u24lambda_u2d2.getRotation()) * party.getRotation().getMultiplier3D();
        float f6 = this.pixelDensity;
        return new Confetti(vector, n2, f, f2, shape, l, bl3, null, vector2, f3, f5, f4, f6, 128, null);
    }

    private final float rotationSpeed(Rotation $this$rotationSpeed) {
        if (!$this$rotationSpeed.getEnabled()) {
            return 0.0f;
        }
        float randomValue = this.random.nextFloat() * 2.0f - 1.0f;
        return $this$rotationSpeed.getSpeed() + $this$rotationSpeed.getSpeed() * $this$rotationSpeed.getVariance() * randomValue;
    }

    private final float getSpeed(Party $this$getSpeed) {
        return $this$getSpeed.getMaxSpeed() == -1.0f ? $this$getSpeed.getSpeed() : ($this$getSpeed.getMaxSpeed() - $this$getSpeed.getSpeed()) * this.random.nextFloat() + $this$getSpeed.getSpeed();
    }

    private final float massWithVariance(Size $this$massWithVariance) {
        return $this$massWithVariance.getMass() + $this$massWithVariance.getMass() * (this.random.nextFloat() * $this$massWithVariance.getMassVariance());
    }

    private final Vector getVelocity(Party $this$getVelocity) {
        float speed = this.getSpeed($this$getVelocity);
        double radian = Math.toRadians(this.getAngle($this$getVelocity));
        float vx = speed * (float)Math.cos(radian);
        float vy = speed * (float)Math.sin(radian);
        return new Vector(vx, vy);
    }

    private final double getAngle(Party $this$getAngle) {
        if ($this$getAngle.getSpread() == 0) {
            return $this$getAngle.getAngle();
        }
        int minAngle = $this$getAngle.getAngle() - $this$getAngle.getSpread() / 2;
        int maxAngle = $this$getAngle.getAngle() + $this$getAngle.getSpread() / 2;
        return (double)(maxAngle - minAngle) * this.random.nextDouble() + (double)minAngle;
    }

    private final Position.Absolute get(Position $this$get, Rect drawArea) {
        Position.Absolute absolute;
        Position position = $this$get;
        if (position instanceof Position.Absolute) {
            absolute = new Position.Absolute(((Position.Absolute)$this$get).getX(), ((Position.Absolute)$this$get).getY());
        } else if (position instanceof Position.Relative) {
            absolute = new Position.Absolute((float)drawArea.width() * (float)((Position.Relative)$this$get).getX(), (float)drawArea.height() * (float)((Position.Relative)$this$get).getY());
        } else {
            if (position instanceof Position.between) {
                Position.Absolute minPos = this.get(((Position.between)$this$get).getMin(), drawArea);
                Position.Absolute maxPos = this.get(((Position.between)$this$get).getMax(), drawArea);
                return new Position.Absolute(this.random.nextFloat() * (maxPos.getX() - minPos.getX()) + minPos.getX(), this.random.nextFloat() * (maxPos.getY() - minPos.getY()) + minPos.getY());
            }
            throw new NoWhenBranchMatchedException();
        }
        return absolute;
    }

    /*
     * WARNING - void declaration
     */
    private final Shape getRandomShape(List<? extends Shape> shapes) {
        Shape shape;
        Shape shape2 = shapes.get(this.random.nextInt(shapes.size()));
        if (shape2 instanceof Shape.DrawableShape) {
            Drawable drawable;
            Object object;
            Drawable.ConstantState constantState = ((Shape.DrawableShape)shape2).getDrawable().getConstantState();
            if (constantState == null) {
                object = null;
            } else {
                Drawable drawable2 = constantState.newDrawable();
                object = drawable = drawable2 == null ? null : drawable2.mutate();
            }
            if (object == null) {
                drawable = ((Shape.DrawableShape)shape2).getDrawable();
            }
            Drawable drawable3 = drawable;
            Intrinsics.checkNotNullExpressionValue((Object)drawable3, (String)"shape.drawable.constantS\u2026utate() ?: shape.drawable");
            Drawable mutatedState = drawable3;
            shape = Shape.DrawableShape.copy$default((Shape.DrawableShape)shape2, mutatedState, false, 2, null);
        } else {
            void var2_2;
            shape = var2_2;
        }
        return shape;
    }

    private final boolean isTimeElapsed() {
        return this.emitterConfig.getEmittingTime() == 0L ? false : this.elapsedTime >= (float)this.emitterConfig.getEmittingTime();
    }

    @Override
    public boolean isFinished() {
        return this.emitterConfig.getEmittingTime() > 0L ? this.elapsedTime >= (float)this.emitterConfig.getEmittingTime() : false;
    }
}

