/*
 * Decompiled with CFR 0.152.
 */
package nl.garvelink.iban;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

public abstract class CountryCodes {
    private static final int SEPA = 256;
    private static final int REMOVE_SEPA_MASK = -257;
    private static final String[] COUNTRY_CODES = new String[]{"AD", "AE", "AL", "AO", "AT", "AZ", "BA", "BE", "BF", "BG", "BH", "BI", "BJ", "BR", "CG", "CH", "CI", "CM", "CR", "CV", "CY", "CZ", "DE", "DK", "DO", "DZ", "EE", "EG", "ES", "FI", "FO", "FR", "GA", "GB", "GE", "GI", "GL", "GR", "GT", "HR", "HU", "IE", "IL", "IR", "IS", "IT", "JO", "KW", "KZ", "LB", "LC", "LI", "LT", "LU", "LV", "MC", "MD", "ME", "MG", "MK", "ML", "MR", "MT", "MU", "MZ", "NL", "NO", "PK", "PL", "PS", "PT", "QA", "RO", "RS", "SA", "SC", "SE", "SI", "SK", "SM", "SN", "ST", "TL", "TN", "TR", "UA", "VG", "XK"};
    private static final int[] COUNTRY_IBAN_LENGTHS = new int[]{24, 23, 28, 25, 276, 28, 20, 272, 27, 278, 22, 16, 28, 29, 27, 277, 28, 27, 21, 25, 284, 280, 278, 274, 28, 24, 276, 27, 280, 274, 18, 283, 27, 278, 22, 279, 18, 283, 28, 277, 284, 278, 23, 26, 282, 283, 30, 30, 20, 28, 32, 277, 276, 276, 277, 283, 24, 22, 27, 19, 28, 27, 287, 30, 25, 274, 271, 24, 284, 29, 281, 29, 280, 22, 24, 31, 280, 275, 280, 283, 28, 25, 23, 24, 26, 29, 24, 20};
    public static final int SHORTEST_IBAN_LENGTH;
    public static final int LONGEST_IBAN_LENGTH;

    static int indexOf(String countryCode) {
        return Arrays.binarySearch(COUNTRY_CODES, countryCode);
    }

    public static int getLengthForCountryCode(String countryCode) {
        int index = CountryCodes.indexOf(countryCode);
        if (index > -1) {
            return COUNTRY_IBAN_LENGTHS[index] & 0xFFFFFEFF;
        }
        return -1;
    }

    public static boolean isSEPACountry(String countryCode) {
        int index = CountryCodes.indexOf(countryCode);
        if (index > -1) {
            return (COUNTRY_IBAN_LENGTHS[index] & 0x100) == 256;
        }
        return false;
    }

    public static Collection<String> getKnownCountryCodes() {
        return Collections.unmodifiableList(Arrays.asList(COUNTRY_CODES));
    }

    public static boolean isKnownCountryCode(String aCountryCode) {
        if (aCountryCode == null || aCountryCode.length() != 2) {
            return false;
        }
        return CountryCodes.indexOf(aCountryCode) >= 0;
    }

    private CountryCodes() {
    }

    static {
        int min = Integer.MAX_VALUE;
        int max = 0;
        for (int countryIbanLength : COUNTRY_IBAN_LENGTHS) {
            int length = 0xFFFFFEFF & countryIbanLength;
            if (length > max) {
                max = length;
            }
            if (length >= min) continue;
            min = length;
        }
        SHORTEST_IBAN_LENGTH = min;
        LONGEST_IBAN_LENGTH = max;
    }
}

