/*
 * Decompiled with CFR 0.152.
 */
package nl.garvelink.iban;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

public abstract class CountryCodes {
    private static final int SEPA = 256;
    private static final int SWIFT = 512;
    private static final int REMOVE_METADATA_MASK = 255;
    private static final String[] COUNTRY_CODES = new String[]{"AD", "AE", "AL", "AO", "AT", "AZ", "BA", "BE", "BF", "BG", "BH", "BI", "BJ", "BR", "BY", "CF", "CG", "CH", "CI", "CM", "CR", "CV", "CY", "CZ", "DE", "DJ", "DK", "DO", "DZ", "EE", "EG", "ES", "FI", "FO", "FR", "GA", "GB", "GE", "GI", "GL", "GQ", "GR", "GT", "GW", "HN", "HR", "HU", "IE", "IL", "IQ", "IR", "IS", "IT", "JO", "KM", "KW", "KZ", "LB", "LC", "LI", "LT", "LU", "LV", "MA", "MC", "MD", "ME", "MG", "MK", "ML", "MR", "MT", "MU", "MZ", "NE", "NI", "NL", "NO", "PK", "PL", "PS", "PT", "QA", "RO", "RS", "SA", "SC", "SE", "SI", "SK", "SM", "SN", "ST", "SV", "TD", "TG", "TL", "TN", "TR", "UA", "VA", "VG", "XK"};
    private static final int[] COUNTRY_IBAN_LENGTHS = new int[]{536, 535, 540, 25, 788, 540, 532, 784, 28, 790, 534, 16, 28, 541, 540, 27, 27, 789, 28, 27, 534, 25, 796, 792, 790, 27, 786, 540, 26, 788, 27, 792, 786, 530, 795, 27, 790, 534, 791, 530, 27, 795, 540, 25, 28, 789, 796, 790, 535, 535, 26, 794, 795, 542, 27, 542, 532, 540, 544, 789, 788, 788, 789, 28, 795, 536, 534, 27, 531, 28, 539, 799, 542, 25, 28, 32, 786, 783, 536, 796, 541, 793, 541, 792, 534, 536, 543, 792, 787, 792, 795, 28, 537, 540, 27, 28, 535, 536, 538, 541, 790, 536, 532};
    public static final int SHORTEST_IBAN_LENGTH;
    public static final int LONGEST_IBAN_LENGTH;

    static int indexOf(String countryCode) {
        return Arrays.binarySearch(COUNTRY_CODES, countryCode);
    }

    public static int getLengthForCountryCode(String countryCode) {
        int index = CountryCodes.indexOf(countryCode);
        if (index > -1) {
            return COUNTRY_IBAN_LENGTHS[index] & 0xFF;
        }
        return -1;
    }

    public static boolean isSEPACountry(String countryCode) {
        int index = CountryCodes.indexOf(countryCode);
        if (index > -1) {
            return (COUNTRY_IBAN_LENGTHS[index] & 0x100) == 256;
        }
        return false;
    }

    public static boolean isInSwiftRegistry(String countryCode) {
        int index = CountryCodes.indexOf(countryCode);
        if (index > -1) {
            return (COUNTRY_IBAN_LENGTHS[index] & 0x200) == 512;
        }
        return false;
    }

    public static Collection<String> getKnownCountryCodes() {
        return Collections.unmodifiableList(Arrays.asList(COUNTRY_CODES));
    }

    public static boolean isKnownCountryCode(String aCountryCode) {
        if (aCountryCode == null || aCountryCode.length() != 2) {
            return false;
        }
        return CountryCodes.indexOf(aCountryCode) >= 0;
    }

    private CountryCodes() {
    }

    static {
        int min = Integer.MAX_VALUE;
        int max = 0;
        for (int countryIbanLength : COUNTRY_IBAN_LENGTHS) {
            int length = 0xFF & countryIbanLength;
            if (length > max) {
                max = length;
            }
            if (length >= min) continue;
            min = length;
        }
        SHORTEST_IBAN_LENGTH = min;
        LONGEST_IBAN_LENGTH = max;
    }
}

