/*
 * Decompiled with CFR 0.152.
 */
package nl.garvelink.iban;

import nl.garvelink.iban.CountryCodes;
import nl.garvelink.iban.IBAN;

public class IBANFieldsCompat {
    private static final int BANK_IDENTIFIER_BEGIN_MASK = 255;
    private static final int BANK_IDENTIFIER_END_SHIFT = 8;
    private static final int BANK_IDENTIFIER_END_MASK = 65280;
    private static final int BRANCH_IDENTIFIER_BEGIN_SHIFT = 16;
    private static final int BRANCH_IDENTIFIER_BEGIN_MASK = 0xFF0000;
    private static final int BRANCH_IDENTIFIER_END_SHIFT = 24;
    private static final int BRANCH_IDENTIFIER_END_MASK = -16777216;
    private static final int[] BANK_CODE_BRANCH_CODE = new int[]{201852932, 1796, 185009924, 0, 2308, 2052, 168232708, 1796, 0, 201852932, 2052, 0, 0, 286002180, 2052, 0, 0, 2308, 0, 0, 2052, 0, 201787140, 2052, 3076, 0, 2052, 2052, 0, 1540, 0, 201852932, 1796, 2052, 2308, 0, 235407364, 1540, 2052, 2052, 0, 185009924, 2052, 0, 0, 2820, 185009924, 235407364, 168232708, 185075716, 0, 2052, 252316165, 2052, 0, 2052, 1796, 2052, 2052, 2308, 2308, 1796, 2052, 0, 235473156, 1540, 1796, 0, 1796, 0, 235473156, 218630148, 201984516, 0, 0, 0, 2052, 2052, 2052, 3076, 2052, 2052, 2052, 2052, 1796, 1540, 3076, 1796, 2308, 2052, 252316165, 0, 201852932, 2052, 0, 0, 1796, 151389700, 2308, 2564, 1796, 2052, 134612484};

    public static String getBankIdentifier(IBAN iban) {
        int index = CountryCodes.indexOf(iban.getCountryCode());
        if (index > -1) {
            int data = BANK_CODE_BRANCH_CODE[index];
            int bankIdBegin = data & 0xFF;
            int bankIdEnd = (data & 0xFF00) >>> 8;
            return bankIdBegin != 0 ? iban.toPlainString().substring(bankIdBegin, bankIdEnd) : null;
        }
        return null;
    }

    public static String getBranchIdentifier(IBAN iban) {
        int index = CountryCodes.indexOf(iban.getCountryCode());
        if (index > -1) {
            int data = BANK_CODE_BRANCH_CODE[index];
            int branchIdBegin = (data & 0xFF0000) >>> 16;
            int branchIdEnd = (data & 0xFF000000) >>> 24;
            return branchIdBegin != 0 ? iban.toPlainString().substring(branchIdBegin, branchIdEnd) : null;
        }
        return null;
    }
}

