/*
 * Decompiled with CFR 0.152.
 */
package nl.garvelink.iban;

import java.time.LocalDate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import nl.garvelink.iban.CountryCodesData;
import nl.garvelink.iban.IBAN;

public abstract class CountryCodes {
    public static final int SHORTEST_IBAN_LENGTH;
    public static final int LONGEST_IBAN_LENGTH;

    static int indexOf(String countryCode) {
        return Arrays.binarySearch(CountryCodesData.COUNTRY_CODES, countryCode);
    }

    static String getBankIdentifier(IBAN iban) {
        int index = CountryCodes.indexOf(iban.getCountryCode());
        if (index > -1) {
            int data = CountryCodesData.BANK_CODE_BRANCH_CODE[index];
            int bankIdBegin = data & 0xFF;
            int bankIdEnd = (data & 0xFF00) >>> 8;
            return bankIdBegin != 0 ? iban.toPlainString().substring(bankIdBegin, bankIdEnd) : null;
        }
        return null;
    }

    static String getBranchIdentifier(IBAN iban) {
        int index = CountryCodes.indexOf(iban.getCountryCode());
        if (index > -1) {
            int data = CountryCodesData.BANK_CODE_BRANCH_CODE[index];
            int branchIdBegin = (data & 0xFF0000) >>> 16;
            int branchIdEnd = (data & 0xFF000000) >>> 24;
            return branchIdBegin != 0 ? iban.toPlainString().substring(branchIdBegin, branchIdEnd) : null;
        }
        return null;
    }

    public static int getLengthForCountryCode(String countryCode) {
        int index = CountryCodes.indexOf(countryCode);
        if (index > -1) {
            return CountryCodesData.COUNTRY_IBAN_LENGTHS[index] & 0xFF;
        }
        return -1;
    }

    public static boolean isSEPACountry(String countryCode) {
        int index = CountryCodes.indexOf(countryCode);
        if (index > -1) {
            return (CountryCodesData.COUNTRY_IBAN_LENGTHS[index] & 0x100) == 256;
        }
        return false;
    }

    public static boolean isInSwiftRegistry(String countryCode) {
        int index = CountryCodes.indexOf(countryCode);
        if (index > -1) {
            return (CountryCodesData.COUNTRY_IBAN_LENGTHS[index] & 0x200) == 512;
        }
        return false;
    }

    public static Collection<String> getKnownCountryCodes() {
        return Collections.unmodifiableList(Arrays.asList(CountryCodesData.COUNTRY_CODES));
    }

    public static boolean isKnownCountryCode(String aCountryCode) {
        if (aCountryCode == null || aCountryCode.length() != 2) {
            return false;
        }
        return CountryCodes.indexOf(aCountryCode) >= 0;
    }

    public static LocalDate getLastUpdateDate() {
        return LocalDate.parse("2020-10-11");
    }

    public static String getLastUpdateRevision() {
        return "88";
    }

    private CountryCodes() {
    }

    static {
        int min = Integer.MAX_VALUE;
        int max = 0;
        for (int countryIbanLength : CountryCodesData.COUNTRY_IBAN_LENGTHS) {
            int length = 0xFF & countryIbanLength;
            if (length > max) {
                max = length;
            }
            if (length >= min) continue;
            min = length;
        }
        SHORTEST_IBAN_LENGTH = min;
        LONGEST_IBAN_LENGTH = max;
    }
}

