/*
 * Decompiled with CFR 0.152.
 */
package nl.garvelink.iban;

import java.util.Comparator;
import java.util.regex.Pattern;
import nl.garvelink.iban.CountryCodes;
import nl.garvelink.iban.Modulo97;
import nl.garvelink.iban.UnknownCountryCodeException;
import nl.garvelink.iban.WrongChecksumException;
import nl.garvelink.iban.WrongLengthException;

public final class IBAN {
    public static final Comparator<IBAN> LEXICAL_ORDER = new Comparator<IBAN>(){

        @Override
        public int compare(IBAN iban, IBAN iban2) {
            return iban.value.compareTo(iban2.value);
        }
    };
    public static final int SHORTEST_POSSIBLE_IBAN = 5;
    private static final Pattern SPACE_PATTERN = Pattern.compile(" ");
    private final String value;
    private final boolean inSwiftRegistry;
    private final boolean sepa;
    private transient String valuePretty;

    private IBAN(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Input is null");
        }
        if (value.length() < 5) {
            throw new IllegalArgumentException("Length is too short to be an IBAN");
        }
        if (value.charAt(2) < '0' || value.charAt(2) > '9' || value.charAt(3) < '0' || value.charAt(3) > '9') {
            throw new IllegalArgumentException("Characters at index 2 and 3 not both numeric.");
        }
        String countryCode = value.substring(0, 2);
        int expectedLength = CountryCodes.getLengthForCountryCode(countryCode);
        if (expectedLength < 0) {
            throw new UnknownCountryCodeException(value);
        }
        if (expectedLength != value.length()) {
            throw new WrongLengthException(value, expectedLength);
        }
        int calculatedChecksum = Modulo97.checksum(value);
        if (calculatedChecksum != 1) {
            throw new WrongChecksumException(value);
        }
        this.value = value;
        this.inSwiftRegistry = CountryCodes.isInSwiftRegistry(countryCode);
        this.sepa = CountryCodes.isSEPACountry(countryCode);
    }

    public static IBAN parse(CharSequence input) {
        if (input == null || input.length() == 0) {
            throw new IllegalArgumentException("Input is null or empty string.");
        }
        if (!IBAN.isLetterOrDigit(input.charAt(0)) || !IBAN.isLetterOrDigit(input.charAt(input.length() - 1))) {
            throw new IllegalArgumentException("Input begins or ends in an invalid character.");
        }
        return new IBAN(IBAN.toPlain(input));
    }

    public static IBAN valueOf(CharSequence input) {
        if (input == null) {
            return null;
        }
        return IBAN.parse(input);
    }

    @Deprecated
    public static int getLengthForCountryCode(String countryCode) {
        return CountryCodes.getLengthForCountryCode(countryCode);
    }

    public String getCountryCode() {
        return this.value.substring(0, 2);
    }

    public String getCheckDigits() {
        return this.value.substring(2, 4);
    }

    public boolean isSEPA() {
        return this.sepa;
    }

    public boolean isInSwiftRegistry() {
        return this.inSwiftRegistry;
    }

    public String toPlainString() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IBAN)) {
            return false;
        }
        return this.value.equals(((IBAN)o).value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        String vp = this.valuePretty;
        if (vp == null) {
            vp = this.valuePretty = IBAN.addSpaces(this.value);
        }
        return vp;
    }

    private static boolean isLetterOrDigit(char c) {
        return c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
    }

    public static String toPlain(CharSequence input) {
        return SPACE_PATTERN.matcher(input).replaceAll("");
    }

    public static String toPretty(CharSequence input) {
        return IBAN.addSpaces(IBAN.toPlain(input));
    }

    private static String addSpaces(CharSequence value) {
        int i;
        int length = value.length();
        int lastPossibleBlock = length - 4;
        StringBuilder sb = new StringBuilder(length + (length - 1) / 4);
        for (i = 0; i < lastPossibleBlock; i += 4) {
            sb.append(value, i, i + 4);
            sb.append(' ');
        }
        sb.append(value, i, length);
        return sb.toString();
    }
}

