/*
 * Decompiled with CFR 0.152.
 */
package nl.geodienstencentrum.maven.plugin.closure.compiler;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.io.Files;
import com.google.javascript.jscomp.CompilationLevel;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.Result;
import com.google.javascript.jscomp.SourceFile;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.List;
import nl.geodienstencentrum.maven.plugin.closure.compiler.Compilation;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="compile", defaultPhase=LifecyclePhase.COMPILE, threadSafe=true)
public class ClosureCompilerMojo
extends AbstractMojo {
    @Parameter(required=true)
    private List<Compilation> compilations;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Log log = this.getLog();
        Preconditions.checkNotNull(this.compilations);
        for (Compilation compilation : this.compilations) {
            String string2;
            List<SourceFile> list = this.getSourceFiles(compilation.getExternFiles());
            List<SourceFile> list2 = this.getSourceFiles(compilation.getSourceFiles());
            for (String string2 : compilation.getExternFiles()) {
                log.debug((CharSequence)("Compiling from extern: " + string2));
            }
            for (String string2 : compilation.getSourceFiles()) {
                log.debug((CharSequence)("Compiling from source: " + string2));
            }
            log.info((CharSequence)("Compiling " + compilation.getOutputFile() + " with level: " + compilation.getCompilationLevel()));
            CompilationLevel compilationLevel = null;
            try {
                compilationLevel = CompilationLevel.valueOf((String)compilation.getCompilationLevel());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new MojoFailureException("Compilation level invalid", (Throwable)illegalArgumentException);
            }
            string2 = compilation.getCompilerOptionsMojo().getCompilerOptions();
            if (null == string2) {
                log.debug((CharSequence)"Compiling with default compiler options");
                string2 = new CompilerOptions();
            }
            log.debug((CharSequence)("Compiler Options:" + string2));
            compilationLevel.setOptionsForCompilationLevel((CompilerOptions)string2);
            Compiler compiler = new Compiler();
            Result result = compiler.compile(list, list2, (CompilerOptions)string2);
            for (JSError jSError : result.warnings) {
                this.getLog().warn((CharSequence)jSError.toString());
            }
            for (JSError jSError : result.errors) {
                this.getLog().error((CharSequence)jSError.toString());
            }
            if (!result.success) {
                throw new MojoFailureException("Compilation failure, check messages above.");
            }
            try {
                Files.createParentDirs((File)compilation.getOutputFile());
                Files.touch((File)compilation.getOutputFile());
                Files.write((CharSequence)compiler.toSource(), (File)compilation.getOutputFile(), (Charset)Charsets.UTF_8);
            }
            catch (IOException iOException) {
                throw new MojoFailureException(compilation.getOutputFile() != null ? compilation.getOutputFile().toString() : iOException.getMessage(), (Throwable)iOException);
            }
        }
    }

    private List<SourceFile> getSourceFiles(List<String> list) {
        Preconditions.checkNotNull(list, (Object)"Filepaths are required.");
        LinkedList<SourceFile> linkedList = new LinkedList<SourceFile>();
        for (String string : list) {
            File file = new File(string);
            linkedList.addAll(this.sourcefileFromFile(file));
        }
        return linkedList;
    }

    private List<SourceFile> sourcefileFromFile(File file) {
        Preconditions.checkNotNull((Object)file, (Object)"The file may not be null.");
        Preconditions.checkArgument((boolean)file.exists(), (Object)"The file must exist.");
        LinkedList<SourceFile> linkedList = new LinkedList<SourceFile>();
        if (file.isDirectory()) {
            for (File file2 : file.listFiles()) {
                linkedList.addAll(this.sourcefileFromFile(file2));
            }
        } else {
            linkedList.add(SourceFile.fromFile((File)file));
        }
        return linkedList;
    }
}

