/*
 * Decompiled with CFR 0.152.
 */
package nl.geodienstencentrum.maven.plugin.sass.compiler;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import nl.geodienstencentrum.maven.plugin.sass.AbstractSassMojo;
import org.apache.commons.io.DirectoryWalker;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="update-stylesheets", defaultPhase=LifecyclePhase.PROCESS_SOURCES)
public class UpdateStylesheetsMojo
extends AbstractSassMojo {
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.isSkip()) {
            this.getLog().info((CharSequence)"Skip compiling Sass templates");
            return;
        }
        boolean bl = true;
        try {
            bl = this.buildRequired();
        }
        catch (IOException iOException) {
            throw new MojoExecutionException("Could not check file timestamps", (Exception)iOException);
        }
        if (!bl) {
            this.getLog().info((CharSequence)"Skip compiling Sass templates, no changes.");
            return;
        }
        this.getLog().info((CharSequence)"Compiling Sass templates");
        StringBuilder stringBuilder = new StringBuilder();
        this.buildBasicSassScript(stringBuilder);
        stringBuilder.append("Sass::Plugin.update_stylesheets");
        String string = stringBuilder.toString();
        this.executeSassScript(string);
    }

    private boolean buildRequired() throws IOException {
        if (!this.buildDirectory.exists()) {
            return true;
        }
        LastModifiedWalker lastModifiedWalker = new LastModifiedWalker(this.getSassSourceDirectory());
        LastModifiedWalker lastModifiedWalker2 = new LastModifiedWalker(this.destination);
        if (lastModifiedWalker.getCount() == 0 || lastModifiedWalker2.getCount() == 0) {
            return true;
        }
        return lastModifiedWalker.getYoungest() > lastModifiedWalker2.getYoungest();
    }

    private class LastModifiedWalker
    extends DirectoryWalker<Void> {
        private Long youngest;
        private Long oldest;
        private int count = 0;

        public LastModifiedWalker(File file) throws IOException {
            this.walk(file, null);
            UpdateStylesheetsMojo.this.getLog().info((CharSequence)("Checked " + this.count + " files for " + file));
        }

        protected void handleFile(File file, int n, Collection<Void> collection) throws IOException {
            long l = file.lastModified();
            this.youngest = this.youngest == null ? l : Math.max(this.youngest, l);
            this.oldest = this.oldest == null ? l : Math.min(this.oldest, l);
            ++this.count;
            super.handleFile(file, n, collection);
        }

        public Long getYoungest() {
            return this.youngest;
        }

        public Long getOldest() {
            return this.oldest;
        }

        public int getCount() {
            return this.count;
        }
    }
}

