/*
 * Decompiled with CFR 0.152.
 */
package nl.geodienstencentrum.maven.plugin.sass;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import nl.geodienstencentrum.maven.plugin.sass.Resource;
import nl.geodienstencentrum.maven.plugin.sass.compiler.CompilerCallback;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.model.FileSet;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.shared.utils.io.IOUtil;
import org.jruby.embed.LocalContextScope;
import org.jruby.embed.ScriptingContainer;

public abstract class AbstractSassMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.build.directory}")
    protected File buildDirectory;
    @Parameter(defaultValue="${project.build.directory}/${project.build.finalName}/css")
    protected File destination;
    @Parameter(defaultValue="true")
    protected boolean failOnError;
    @Parameter
    private Map<String, String> sassOptions = new HashMap<String, String>((Map<String, String>)ImmutableMap.of((Object)"unix_newlines", (Object)"true", (Object)"cache", (Object)"true", (Object)"always_update", (Object)"true", (Object)"style", (Object)":expanded"));
    @Parameter
    private List<Resource> resources = Collections.emptyList();
    @Parameter(defaultValue="${project.build.directory}/rubygems")
    private String[] gemPaths = new String[0];
    @Parameter
    private String[] gems = new String[0];
    @Deprecated
    @Parameter(defaultValue="false")
    private boolean useCompass;
    @Parameter(defaultValue="false")
    private boolean useBourbon;
    @Deprecated
    @Parameter(property="compassConfigFile")
    private File compassConfigFile;
    @Parameter(defaultValue="${basedir}/src/main/sass", property="sassSourceDirectory")
    private File sassSourceDirectory;
    @Parameter
    private String[] includes = new String[]{"**/*.scss"};
    @Parameter
    private String[] excludes;
    @Parameter(defaultValue="..")
    private String relativeOutputDirectory;
    @Deprecated
    @Parameter(defaultValue="2.1")
    private Float rubyVersion;
    @Parameter(defaultValue="false")
    private boolean skip;

    protected void executeSassScript(String string) throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            return;
        }
        Log log = this.getLog();
        log.debug((CharSequence)("Execute Sass Ruby script:\n\n" + string + "\n\n"));
        ScriptingContainer scriptingContainer = new ScriptingContainer(LocalContextScope.SINGLETHREAD);
        CompilerCallback compilerCallback = new CompilerCallback(log);
        scriptingContainer.setHomeDirectory("uri:classloader://META-INF/jruby.home");
        scriptingContainer.put("$compiler_callback", (Object)compilerCallback);
        scriptingContainer.runScriptlet(string);
        if (this.failOnError && compilerCallback.hadError()) {
            throw new MojoFailureException("Sass compilation encountered errors (see above for details).");
        }
        log.debug((CharSequence)"\n");
    }

    protected void buildBasicSassScript(StringBuilder stringBuilder) throws MojoExecutionException {
        String string;
        int n;
        Object object;
        Log log = this.getLog();
        stringBuilder.append("require 'rubygems'\n");
        if (this.gemPaths.length > 0) {
            stringBuilder.append("env = { 'GEM_PATH' => [\n");
            for (String string2 : this.gemPaths) {
                stringBuilder.append("    '").append(string2).append("',\n");
            }
            object = System.getenv("GEM_PATH");
            if (object != null) {
                String[] stringArray = ((String)object).split(File.pathSeparator);
                n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    string = stringArray[i];
                    stringBuilder.append("    '").append(string).append("',\n");
                }
            }
            stringBuilder.setLength(stringBuilder.length() - 2);
            stringBuilder.append("\n].uniq.join(File::PATH_SEPARATOR) }\n");
            stringBuilder.append("Gem.paths = env\n");
        }
        object = this.gems;
        int n2 = ((String[])object).length;
        for (n = 0; n < n2; ++n) {
            String string3 = object[n];
            stringBuilder.append("require '").append(string3).append("'\n");
        }
        stringBuilder.append("require 'sass/plugin'\n");
        stringBuilder.append("require 'java'\n");
        if (this.useCompass) {
            log.info((CharSequence)"Running with Compass enabled.");
            log.warn((CharSequence)"Compass support is deprecated, it will be removed in version 3.0, see https://github.com/GeoDienstenCentrum/sass-maven-plugin/issues/77");
            stringBuilder.append("require 'compass'\n");
            stringBuilder.append("require 'compass/exec'\n");
            stringBuilder.append("require 'compass/core'\n");
            stringBuilder.append("require 'compass/import-once'\n");
            if (this.compassConfigFile != null) {
                stringBuilder.append("Compass.add_project_configuration '").append(this.compassConfigFile.getAbsolutePath()).append("'\n");
            } else {
                stringBuilder.append("Compass.add_project_configuration \n");
            }
            this.sassOptions.put("load_paths", "Compass.configuration.sass_load_paths");
        }
        if ((object = this.getTemplateLocations()).hasNext()) {
            Map.Entry entry = (Map.Entry)object.next();
            this.sassOptions.put("template_location", "'" + (String)entry.getKey() + "'");
            this.sassOptions.put("css_location", "'" + (String)entry.getValue() + "'");
        }
        if (!this.sassOptions.containsKey("cache_location")) {
            File file = new File(this.buildDirectory, "sass_cache");
            String string4 = file.toString();
            this.sassOptions.put("cache_location", "'" + FilenameUtils.separatorsToUnix((String)string4) + "'");
        }
        stringBuilder.append("Sass::Plugin.options.merge!(\n");
        Object object2 = this.sassOptions.entrySet().iterator();
        while (object2.hasNext()) {
            Map.Entry<String, String> entry = object2.next();
            String string5 = entry.getKey();
            string = entry.getValue();
            stringBuilder.append("    :").append(string5).append(" => ").append(string);
            if (object2.hasNext()) {
                stringBuilder.append(",");
            }
            stringBuilder.append('\n');
        }
        stringBuilder.append(")\n");
        while (object.hasNext()) {
            object2 = (Map.Entry)object.next();
            stringBuilder.append("Sass::Plugin.add_template_location('").append((String)object2.getKey()).append("', '").append((String)object2.getValue()).append("')\n");
        }
        if (this.useBourbon) {
            log.info((CharSequence)"Running with Bourbon enabled.");
            object2 = this.buildDirectory + "/bourbon";
            this.extractBourbonResources((String)object2);
            stringBuilder.append("Sass::Plugin.add_template_location('").append((String)object2).append("/app/assets/stylesheets', '").append(this.destination).append("')\n");
        }
        stringBuilder.append("Sass::Plugin.on_compilation_error {|error, template, css| $compiler_callback.compilationError(error.message, template, css) }\n");
        stringBuilder.append("Sass::Plugin.on_updated_stylesheet {|template, css| $compiler_callback.updatedStylesheeet(template, css) }\n");
        stringBuilder.append("Sass::Plugin.on_template_modified {|template| $compiler_callback.templateModified(template) }\n");
        stringBuilder.append("Sass::Plugin.on_template_created {|template| $compiler_callback.templateCreated(template) }\n");
        stringBuilder.append("Sass::Plugin.on_template_deleted {|template| $compiler_callback.templateDeleted(template) }\n");
        if (log.isDebugEnabled()) {
            stringBuilder.append("require 'pp'\n");
            stringBuilder.append("pp Sass::Plugin.options\n");
            if (this.useCompass) {
                stringBuilder.append("pp Compass.base_directory\n");
                stringBuilder.append("pp Compass::Core.base_directory\n");
                stringBuilder.append("pp Compass::configuration\n");
            }
        }
    }

    private Iterator<Map.Entry<String, String>> getTemplateLocations() {
        Object object;
        Log log = this.getLog();
        ImmutableList immutableList = this.resources;
        if (immutableList.isEmpty()) {
            log.info((CharSequence)"No resource element was specified, using short configuration.");
            object = new Resource();
            ((Resource)object).source = new FileSet();
            if (this.sassSourceDirectory != null) {
                log.debug((CharSequence)("Setting source directory: " + this.sassSourceDirectory.toString()));
                ((Resource)object).source.setDirectory(this.sassSourceDirectory.toString());
            } else {
                log.error((CharSequence)("\"" + this.sassSourceDirectory + "\" is not a directory."));
                ((Resource)object).source.setDirectory("./src/main/sass");
            }
            if (this.includes != null) {
                log.debug((CharSequence)("Setting includes: " + Arrays.toString(this.includes)));
                ((Resource)object).source.setIncludes(Arrays.asList(this.includes));
            }
            if (this.excludes != null) {
                log.debug((CharSequence)("Setting excludes: " + Arrays.toString(this.excludes)));
                ((Resource)object).source.setExcludes(Arrays.asList(this.excludes));
            }
            ((Resource)object).relativeOutputDirectory = this.relativeOutputDirectory;
            ((Resource)object).destination = this.destination;
            immutableList = ImmutableList.of((Object)object);
        }
        object = new ArrayList();
        for (Resource resource : immutableList) {
            for (Map.Entry<String, String> entry : resource.getDirectoriesAndDestinations(log).entrySet()) {
                log.info((CharSequence)("Queueing Sass template for compile: " + entry.getKey() + " => " + entry.getValue()));
                object.add(entry);
            }
        }
        return object.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractBourbonResources(String string) {
        Log log = this.getLog();
        try {
            File file = new File(string);
            if (file.isDirectory()) {
                log.info((CharSequence)"Bourbon resources seems to have been extracted before.");
                return;
            }
            log.info((CharSequence)("Extracting Bourbon resources to: " + string));
            file.mkdirs();
            URL uRL = ((Object)((Object)this)).getClass().getClassLoader().getResource("scss-report.xsl");
            String string2 = uRL.getFile();
            int n = string2.indexOf("!");
            String string3 = string2.substring(0, n);
            File file2 = new File(new URI(string3));
            JarFile jarFile = new JarFile(file2);
            Enumeration<JarEntry> enumeration = jarFile.entries();
            while (enumeration.hasMoreElements()) {
                JarEntry jarEntry = enumeration.nextElement();
                if (!jarEntry.getName().contains("app/assets/stylesheets")) continue;
                n = jarEntry.getName().indexOf("app/assets/stylesheets");
                String string4 = string + File.separator + jarEntry.getName().substring(n);
                File file3 = new File(string4);
                if (string4.endsWith("/")) {
                    file3.mkdirs();
                    continue;
                }
                FileOutputStream fileOutputStream = new FileOutputStream(file3);
                try {
                    IOUtil.copy((InputStream)jarFile.getInputStream(jarEntry), (OutputStream)fileOutputStream);
                }
                finally {
                    IOUtil.close((OutputStream)fileOutputStream);
                }
            }
        }
        catch (IOException | URISyntaxException exception) {
            log.error((CharSequence)"Error extracting Bourbon resources.", (Throwable)exception);
        }
    }

    protected List<Resource> getResources() {
        return this.resources;
    }

    @Deprecated
    protected boolean isUseCompass() {
        return this.useCompass;
    }

    protected boolean isSkip() {
        return this.skip;
    }

    protected File getSassSourceDirectory() {
        return this.sassSourceDirectory;
    }
}

