/*
 * Decompiled with CFR 0.152.
 */
package nl.geodienstencentrum.maven.plugin.sass.report;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.StringWriter;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.plugin.logging.Log;

public class SCSSLintReportGenerator {
    private final Sink sink;
    private final String description;
    private final File xmlFile;
    private final Log log;

    public SCSSLintReportGenerator(Sink sink, String string, File file, Log log) {
        this.sink = sink;
        this.description = string;
        this.xmlFile = file;
        this.log = log;
    }

    public void generateReport() {
        this.sink.head();
        this.sink.title();
        this.sink.text(this.description);
        this.sink.title_();
        this.sink.head_();
        this.sink.body();
        this.sink.rawText(this.translateXML());
        this.sink.body_();
        this.sink.flush();
        this.sink.close();
    }

    private String translateXML() {
        String string = null;
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Templates templates = transformerFactory.newTemplates(new StreamSource(this.getClass().getClassLoader().getResourceAsStream("scss-report.xsl")));
            Transformer transformer = templates.newTransformer();
            this.log.debug((CharSequence)("loading scss-ling xml results: " + this.xmlFile.getAbsolutePath()));
            StreamSource streamSource = new StreamSource(new FileInputStream(this.xmlFile));
            StringWriter stringWriter = new StringWriter();
            StreamResult streamResult = new StreamResult(stringWriter);
            transformer.transform(streamSource, streamResult);
            string = stringWriter.toString();
        }
        catch (FileNotFoundException | TransformerConfigurationException exception) {
            this.log.error((CharSequence)("Error during xml conversion of " + this.xmlFile), (Throwable)exception);
        }
        catch (TransformerException transformerException) {
            SourceLocator sourceLocator = transformerException.getLocator();
            int n = sourceLocator.getColumnNumber();
            int n2 = sourceLocator.getLineNumber();
            this.log.error((CharSequence)("Error during xml transformation of " + this.xmlFile + "line: " + n2 + ", col: " + n), (Throwable)transformerException);
        }
        this.log.debug((CharSequence)("translated xml:\n" + string));
        return string;
    }
}

