/*
 * Decompiled with CFR 0.152.
 */
package nl.geodienstencentrum.maven.plugin.sass;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.model.FileSet;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.StringUtils;

public class Resource {
    protected FileSet source;
    protected String relativeOutputDirectory;
    protected File destination;

    public Map<String, String> getDirectoriesAndDestinations(Log log) {
        File file = new File(this.source.getDirectory());
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        if (!file.exists()) {
            log.error((CharSequence)("Specified sourcedirectory (" + file + ") does not exist."));
            return linkedHashMap;
        }
        DirectoryScanner directoryScanner = new DirectoryScanner();
        directoryScanner.setBasedir(file);
        directoryScanner.setIncludes(this.source.getIncludes().toArray(new String[this.source.getIncludes().size()]));
        directoryScanner.setExcludes(this.source.getExcludes().toArray(new String[this.source.getExcludes().size()]));
        directoryScanner.addDefaultExcludes();
        directoryScanner.scan();
        linkedHashMap.put(FilenameUtils.separatorsToUnix((String)file.toString()), FilenameUtils.separatorsToUnix((String)this.destination.toString()));
        for (String string : directoryScanner.getIncludedDirectories()) {
            if (string.isEmpty()) continue;
            String string2 = StringUtils.difference((String)file.toString(), (String)string);
            File file2 = new File(file, string);
            File file3 = new File(this.destination, string2);
            if (this.relativeOutputDirectory != null && !this.relativeOutputDirectory.isEmpty()) {
                file3 = new File(file3, this.relativeOutputDirectory);
            }
            linkedHashMap.put(FilenameUtils.separatorsToUnix((String)file2.toString()), FilenameUtils.separatorsToUnix((String)file3.toString()));
        }
        return linkedHashMap;
    }
}

