/*
 * Decompiled with CFR 0.152.
 */
package nl.geodienstencentrum.maven.plugin.sass.report;

import com.google.common.primitives.Ints;
import java.io.File;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import nl.geodienstencentrum.maven.plugin.sass.AbstractSassMojo;
import nl.geodienstencentrum.maven.plugin.sass.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="scss-lint", defaultPhase=LifecyclePhase.COMPILE, executionStrategy="once-per-session", threadSafe=true)
public class SCSSLintMojo
extends AbstractSassMojo {
    @Parameter(defaultValue="${project.build.directory}/scss-lint.xml", readonly=true)
    private File outputFile;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Log log = this.getLog();
        this.outputFile.getParentFile().mkdirs();
        log.info((CharSequence)("Linting Sass sources in: " + this.getSassSourceDirectory()));
        StringBuilder stringBuilder = new StringBuilder();
        this.buildBasicSassScript(stringBuilder);
        log.debug((CharSequence)("scss-lint ruby script:\n" + stringBuilder));
        System.setProperty("org.jruby.embed.localcontext.scope", "threadsafe");
        ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
        ScriptEngine scriptEngine = scriptEngineManager.getEngineByName("jruby");
        ScriptContext scriptContext = scriptEngine.getContext();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("--format=Checkstyle");
        arrayList.add("-o" + this.outputFile);
        arrayList.addAll(this.getSourceDirs());
        scriptContext.setAttribute("javax.script.argv", arrayList.toArray(new String[arrayList.size()]), 200);
        try {
            log.info((CharSequence)("Reporting scss lint in: " + this.outputFile.getAbsolutePath()));
            ExitCode exitCode = ExitCode.getExitCode(Ints.checkedCast((long)((Long)scriptEngine.eval(stringBuilder.toString(), scriptContext))));
            log.debug((CharSequence)("scss-lint result: " + exitCode.toString()));
            switch (exitCode) {
                case CODE_0: {
                    log.info((CharSequence)exitCode.msg());
                    break;
                }
                case CODE_1: {
                    log.warn((CharSequence)exitCode.msg());
                    break;
                }
                case CODE_2: {
                    log.error((CharSequence)exitCode.toString());
                    if (this.failOnError) {
                        throw new MojoFailureException(exitCode.toString());
                    }
                }
                default: {
                    log.error((CharSequence)exitCode.toString());
                    throw new MojoExecutionException(exitCode.toString());
                }
            }
        }
        catch (ScriptException scriptException) {
            throw new MojoExecutionException("Failed to execute scss-lint Ruby script:\n" + stringBuilder, (Exception)scriptException);
        }
    }

    @Override
    protected void buildBasicSassScript(StringBuilder stringBuilder) throws MojoExecutionException {
        Log log = this.getLog();
        stringBuilder.append("require 'scss_lint'\n");
        stringBuilder.append("require 'scss_lint/cli'\n");
        stringBuilder.append("require 'scss_lint_reporter_checkstyle'\n");
        if (log.isDebugEnabled()) {
            stringBuilder.append("require 'pp'\n");
            stringBuilder.append("puts 'parameters: '\n");
            stringBuilder.append("pp ARGV\n");
        }
        stringBuilder.append("SCSSLint::CLI.new.run(ARGV)\n");
    }

    private Set<String> getSourceDirs() {
        HashSet<String> hashSet = new HashSet<String>();
        List<Resource> list = this.getResources();
        if (list.isEmpty()) {
            hashSet.add(this.getSassSourceDirectory().getPath());
        }
        for (Resource resource : list) {
            hashSet.addAll(resource.getDirectoriesAndDestinations(this.getLog()).keySet());
        }
        return hashSet;
    }

    public static enum ExitCode {
        CODE_0(0, "No lints were found"),
        CODE_1(1, "Lints with a severity of 'warning' were reported (no errors)"),
        CODE_2(2, "One or more errors were reported (and any number of warnings)"),
        CODE_64(64, "Command line usage error (invalid flag, etc.)"),
        CODE_66(66, "Input file did not exist or was not readable"),
        CODE_70(70, "Internal software error"),
        CODE_78(78, "Configuration error");

        private static final HashMap<Integer, ExitCode> lookup;
        private final String msg;
        private final int code;

        private ExitCode(int n2, String string2) {
            this.code = n2;
            this.msg = string2;
        }

        String msg() {
            return this.msg;
        }

        int code() {
            return this.code;
        }

        static ExitCode getExitCode(int n) {
            return lookup.get(n);
        }

        public String toString() {
            return this.code + ": " + this.msg;
        }

        static {
            lookup = new HashMap();
            for (ExitCode exitCode : EnumSet.allOf(ExitCode.class)) {
                lookup.put(exitCode.code, exitCode);
            }
        }
    }
}

