/*
 * Decompiled with CFR 0.152.
 */
package nl.geodienstencentrum.maven.plugin.sass;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.model.FileSet;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.StringUtils;

public class Resource {
    protected FileSet source;
    protected String relativeOutputDirectory;
    protected File destination;

    public Map<String, String> getDirectoriesAndDestinations(Log log) {
        File sourceDirectory = new File(this.source.getDirectory());
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        if (!sourceDirectory.exists()) {
            log.error((CharSequence)("Specified sourcedirectory (" + sourceDirectory + ") does not exist."));
            return result;
        }
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(sourceDirectory);
        scanner.setIncludes(this.source.getIncludes().toArray(new String[this.source.getIncludes().size()]));
        scanner.setExcludes(this.source.getExcludes().toArray(new String[this.source.getExcludes().size()]));
        scanner.addDefaultExcludes();
        scanner.scan();
        result.put(FilenameUtils.separatorsToUnix((String)sourceDirectory.toString()), FilenameUtils.separatorsToUnix((String)this.destination.toString()));
        for (String included : scanner.getIncludedDirectories()) {
            if (included.isEmpty()) continue;
            String subdir = StringUtils.difference((String)sourceDirectory.toString(), (String)included);
            File sourceDir = new File(sourceDirectory, included);
            File destDir = new File(this.destination, subdir);
            if (this.relativeOutputDirectory != null && !this.relativeOutputDirectory.isEmpty()) {
                destDir = new File(destDir, this.relativeOutputDirectory);
            }
            result.put(FilenameUtils.separatorsToUnix((String)sourceDir.toString()), FilenameUtils.separatorsToUnix((String)destDir.toString()));
        }
        return result;
    }
}

