/*
 * Decompiled with CFR 0.152.
 */
package com.wakaleo.schemaspy;

import com.wakaleo.schemaspy.MavenSchemaAnalyzer;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;

@Mojo(name="schemaspy", defaultPhase=LifecyclePhase.SITE)
public class SchemaSpyReport
extends AbstractMavenReport {
    @Parameter(property="targetDirectory", defaultValue="${project.build.directory}")
    private File targetDirectory;
    @Parameter(property="outputDirectory", defaultValue="${project.build.directory}/site")
    private String outputDirectory;
    @Component
    private Renderer siteRenderer;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(property="database", required=true)
    private String database;
    @Parameter(property="host")
    private String host;
    @Parameter(property="port")
    private String port;
    @Parameter(property="databaseType")
    private String databaseType;
    @Parameter(property="user")
    private String user;
    @Parameter(property="schema")
    private String schema;
    @Parameter(property="password")
    private String password;
    @Parameter(property="pathToDrivers")
    private String pathToDrivers;
    @Parameter(property="schemaDescription")
    private String schemaDescription;
    @Parameter(property="includeTableNamesRegex")
    private String includeTableNamesRegex;
    @Parameter(property="excludeColumnNamesRegex")
    private String excludeColumnNamesRegex;
    @Parameter(property="allowHtmlInComments")
    private Boolean allowHtmlInComments;
    @Deprecated
    @Parameter(property="commentsInitiallyDisplayed")
    private Boolean commentsInitiallyDisplayed;
    @Parameter(property="noImplied")
    private Boolean noImplied;
    @Parameter(property="noHtml")
    private Boolean noHtml;
    @Parameter(property="logLevel")
    private String logLevel;
    @Parameter(property="useDriverManager")
    private Boolean useDriverManager;
    @Parameter(property="cssStylesheet")
    private String cssStylesheet;
    @Parameter(property="singleSignOn")
    private Boolean singleSignOn;
    @Parameter(property="lowQuality")
    private Boolean lowQuality;
    @Parameter(property="highQuality")
    private Boolean highQuality;
    @Parameter(property="showAllSchemas")
    private Boolean showAllSchemas;
    @Parameter(property="schemas")
    private String schemas;
    @Parameter(property="noSchema")
    private Boolean noSchema;
    @Parameter(property="noRows")
    private Boolean noRows;
    @Parameter(property="noViews")
    private Boolean noViews;
    @Parameter(property="connprops")
    private String connprops;
    @Deprecated
    @Parameter(property="noAds", defaultValue="true")
    private Boolean noAds;
    @Deprecated
    @Parameter(property="noLogo", defaultValue="true")
    private Boolean noLogo;
    @Parameter(property="catalog", defaultValue="%")
    private String catalog;
    @Parameter(property="vizjs", defaultValue="true")
    protected boolean vizjs = false;
    @Parameter(property="runOnExecutionRoot", defaultValue="false")
    protected boolean runOnExecutionRoot = false;
    private MavenSchemaAnalyzer analyzer;

    protected void setSchemaAnalyzer(MavenSchemaAnalyzer analyzer) {
        this.analyzer = analyzer;
    }

    private void addToArguments(List<String> argList, String parameter, Boolean value) {
        if (value != null && value.booleanValue()) {
            argList.add(parameter);
            argList.add(String.valueOf(true));
        }
    }

    private void addFlagToArguments(List<String> argList, String parameter, Boolean value) {
        if (value != null && value.booleanValue()) {
            argList.add(parameter);
        }
    }

    private void addToArguments(List<String> argList, String parameter, String value) {
        if (value != null) {
            argList.add(parameter);
            argList.add(value);
        }
    }

    protected void executeReport(Locale locale) throws MavenReportException {
        if (this.targetDirectory == null) {
            this.targetDirectory = new File("target");
        }
        this.targetDirectory.mkdirs();
        File siteDir = new File(this.targetDirectory, "site");
        siteDir.mkdirs();
        File outputDir = null;
        if (this.outputDirectory == null) {
            outputDir = new File(siteDir, "schemaspy");
            outputDir.mkdirs();
            this.outputDirectory = outputDir.getAbsolutePath();
        } else {
            outputDir = new File(new File(this.outputDirectory), "schemaspy");
            outputDir.mkdirs();
        }
        String schemaSpyDirectory = outputDir.getAbsolutePath();
        this.getLog().debug((CharSequence)("SchemaSpy output directory: " + schemaSpyDirectory));
        ArrayList<String> argList = new ArrayList<String>();
        this.addToArguments(argList, "-dp", this.pathToDrivers);
        this.addToArguments(argList, "-db", this.database);
        this.addToArguments(argList, "-host", this.host);
        this.addToArguments(argList, "-port", this.port);
        this.addToArguments(argList, "-t", this.databaseType);
        this.addToArguments(argList, "-u", this.user);
        this.addToArguments(argList, "-p", this.password);
        if (null != this.schema && this.schema.contains(",")) {
            this.addToArguments(argList, "-schemas", this.schema);
        } else {
            this.addToArguments(argList, "-s", this.schema);
        }
        this.addToArguments(argList, "-o", schemaSpyDirectory);
        this.addToArguments(argList, "-desc", this.schemaDescription);
        this.addToArguments(argList, "-i", this.includeTableNamesRegex);
        this.addToArguments(argList, "-x", this.excludeColumnNamesRegex);
        this.addFlagToArguments(argList, "-ahic", this.allowHtmlInComments);
        this.addFlagToArguments(argList, "-noimplied", this.noImplied);
        this.addFlagToArguments(argList, "-nohtml", this.noHtml);
        this.addToArguments(argList, "-loglevel", this.logLevel);
        this.addFlagToArguments(argList, "-norows", this.noRows);
        this.addFlagToArguments(argList, "-noviews", this.noViews);
        this.addFlagToArguments(argList, "-noschema", this.noSchema);
        this.addFlagToArguments(argList, "-all", this.showAllSchemas);
        this.addToArguments(argList, "-schemas", this.schemas);
        this.addToArguments(argList, "-useDriverManager", this.useDriverManager);
        this.addToArguments(argList, "-css", this.cssStylesheet);
        this.addFlagToArguments(argList, "-sso", this.singleSignOn);
        this.addFlagToArguments(argList, "-lq", this.lowQuality);
        this.addFlagToArguments(argList, "-hq", this.highQuality);
        this.addToArguments(argList, "-connprops", this.connprops);
        this.addFlagToArguments(argList, "-cid", this.commentsInitiallyDisplayed);
        this.addFlagToArguments(argList, "-noads", this.noAds);
        this.addFlagToArguments(argList, "-nologo", this.noLogo);
        this.addToArguments(argList, "-cat", this.catalog);
        this.addFlagToArguments(argList, "-vizjs", this.vizjs);
        if (this.getLog().isDebugEnabled()) {
            this.addFlagToArguments(argList, "-debug", true);
        }
        this.getLog().debug((CharSequence)("SchemaSpy arguments: " + argList));
        try {
            if (this.analyzer == null) {
                this.analyzer = new MavenSchemaAnalyzer();
                this.analyzer.applyConfiguration(argList);
            }
            this.analyzer.analyze();
        }
        catch (Exception e) {
            throw new MavenReportException(e.getMessage(), e);
        }
    }

    public boolean canGenerateReport() {
        return !this.runOnExecutionRoot || this.project.isExecutionRoot();
    }

    protected String getOutputDirectory() {
        return this.outputDirectory;
    }

    protected MavenProject getProject() {
        return this.project;
    }

    protected Renderer getSiteRenderer() {
        return this.siteRenderer;
    }

    public String getDescription(Locale locale) {
        return "SchemaSpy database documentation";
    }

    public String getName(Locale locale) {
        return "SchemaSpy";
    }

    public String getOutputName() {
        return "schemaspy/index";
    }

    public boolean isExternalReport() {
        return true;
    }
}

