/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.checkers.fieldchecks;

import java.lang.reflect.Field;
import nl.jqno.equalsverifier.internal.checkers.fieldchecks.FieldCheck;
import nl.jqno.equalsverifier.internal.reflection.FieldAccessor;
import nl.jqno.equalsverifier.internal.reflection.ObjectAccessor;
import nl.jqno.equalsverifier.internal.util.Assert;
import nl.jqno.equalsverifier.internal.util.Formatter;

public class FloatAndDoubleFieldCheck<T>
implements FieldCheck<T> {
    @Override
    public void execute(ObjectAccessor<T> referenceAccessor, ObjectAccessor<T> copyAccessor, FieldAccessor fieldAccessor) {
        T copy;
        T reference;
        Class<?> type = fieldAccessor.getFieldType();
        Field field = fieldAccessor.getField();
        if (this.isFloat(type)) {
            reference = referenceAccessor.withFieldSetTo(field, Float.valueOf(Float.NaN)).get();
            copy = copyAccessor.withFieldSetTo(field, Float.valueOf(Float.NaN)).get();
            Assert.assertEquals(Formatter.of("Float: equals doesn't use Float.compare for field %%.", field.getName()), reference, copy);
        }
        if (this.isDouble(type)) {
            reference = referenceAccessor.withFieldSetTo(field, Double.NaN).get();
            copy = copyAccessor.withFieldSetTo(field, Double.NaN).get();
            Assert.assertEquals(Formatter.of("Double: equals doesn't use Double.compare for field %%.", field.getName()), reference, copy);
        }
    }

    private boolean isFloat(Class<?> type) {
        return type == Float.TYPE || type == Float.class;
    }

    private boolean isDouble(Class<?> type) {
        return type == Double.TYPE || type == Double.class;
    }
}

